/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup.containers;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;

public abstract class ContainerSourceContainer
extends CompositeSourceContainer {
    private IContainer fContainer = null;
    private boolean fSubfolders = false;
    private URI fRootURI = null;
    private IFileStore fRootFile = null;
    private IWorkspaceRoot fRoot = null;

    public ContainerSourceContainer(IContainer container, boolean subfolders) {
        this.fContainer = container;
        this.fSubfolders = subfolders;
        this.fRootURI = this.fContainer.getLocationURI();
        if (this.fRootURI != null) {
            try {
                this.fRootFile = EFS.getStore(this.fRootURI);
            }
            catch (CoreException coreException) {}
            this.fRoot = ResourcesPlugin.getWorkspace().getRoot();
        }
    }

    public IContainer getContainer() {
        return this.fContainer;
    }

    @Override
    public Object[] findSourceElements(String name) throws CoreException {
        ArrayList<Object> sources = new ArrayList<Object>();
        if (this.validateFile(name)) {
            IFile file = this.fContainer.getFile(new Path(name));
            if (file.exists()) {
                sources.add(file);
            } else {
                IFileStore target;
                if (this.fRootURI == null) {
                    return EMPTY;
                }
                if (this.fRootFile != null && (target = this.fRootFile.getFileStore(new Path(name))).fetchInfo().exists()) {
                    IFile[] files = this.fRoot.findFilesForLocationURI(target.toURI());
                    if (this.isFindDuplicates() && files.length > 1) {
                        Collections.addAll(sources, files);
                    } else if (files.length > 0) {
                        sources.add(files[0]);
                    }
                }
            }
        }
        if (this.isFindDuplicates() && this.fSubfolders || sources.isEmpty() && this.fSubfolders) {
            ISourceContainer[] iSourceContainerArray = this.getSourceContainers();
            int n = iSourceContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer container = iSourceContainerArray[n2];
                Object[] objects = container.findSourceElements(name);
                if (objects != null && objects.length != 0) {
                    if (this.isFindDuplicates()) {
                        Collections.addAll(sources, objects);
                    } else {
                        sources.add(objects[0]);
                        break;
                    }
                }
                ++n2;
            }
        }
        if (sources.isEmpty()) {
            return EMPTY;
        }
        return sources.toArray();
    }

    @Override
    public String getName() {
        return this.getContainer().getName();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ContainerSourceContainer) {
            ContainerSourceContainer loc = (ContainerSourceContainer)obj;
            return loc.getContainer().equals(this.getContainer());
        }
        return false;
    }

    public int hashCode() {
        return this.getContainer().hashCode();
    }

    @Override
    public boolean isComposite() {
        return this.fSubfolders;
    }

    @Override
    protected ISourceContainer[] createSourceContainers() throws CoreException {
        if (this.fSubfolders) {
            ISourceContainer[] containers;
            IResource[] resources = this.getContainer().members();
            ArrayList<FolderSourceContainer> list = new ArrayList<FolderSourceContainer>(resources.length);
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 2) {
                    list.add(new FolderSourceContainer((IFolder)resource, this.fSubfolders));
                }
                ++n2;
            }
            ISourceContainer[] iSourceContainerArray = containers = list.toArray(new ISourceContainer[list.size()]);
            int n3 = containers.length;
            n = 0;
            while (n < n3) {
                ISourceContainer container = iSourceContainerArray[n];
                container.init(this.getDirector());
                ++n;
            }
            return containers;
        }
        return new ISourceContainer[0];
    }

    private boolean validateFile(String name) {
        IContainer container = this.getContainer();
        IPath path = container.getFullPath().append(name);
        return ResourcesPlugin.getWorkspace().validatePath(path.toOSString(), 1).isOK();
    }
}

