/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.debug.core.sourcelookup.containers.DefaultSourceContainer;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSourceLookupDirector
implements ISourceLookupDirector,
ILaunchConfigurationListener,
ILaunchListener {
    protected String fId;
    protected ArrayList<ISourceLookupParticipant> fParticipants = new ArrayList();
    protected ISourceContainer[] fSourceContainers = null;
    protected ILaunchConfiguration fConfig;
    protected boolean fDuplicates = false;
    protected ISourcePathComputer fComputer = null;
    protected Map<Object, Object> fResolvedElements = null;
    private ISourceLookupParticipant fCurrentParticipant;
    protected static final IStatus fPromptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    protected static final IStatus fResolveDuplicatesStatus = new Status(1, "org.eclipse.debug.ui", 205, "", null);
    protected static final String DIRECTOR_ROOT_NODE = "sourceLookupDirector";
    protected static final String CONTAINERS_NODE = "sourceContainers";
    protected static final String DUPLICATES_ATTR = "duplicates";
    protected static final String CONTAINER_NODE = "container";
    protected static final String CONTAINER_TYPE_ATTR = "typeId";
    protected static final String CONTAINER_MEMENTO_ATTR = "memento";

    public void setId(String id) {
        this.fId = id;
    }

    @Override
    public synchronized void dispose() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunchConfigurationListener(this);
        launchManager.removeLaunchListener(this);
        for (ISourceLookupParticipant participant : this.fParticipants) {
            if (participant == this) continue;
            participant.dispose();
        }
        this.fParticipants.clear();
        if (this.fSourceContainers != null) {
            ISourceContainer[] iSourceContainerArray = this.fSourceContainers;
            int n = this.fSourceContainers.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer container = iSourceContainerArray[n2];
                container.dispose();
                ++n2;
            }
        }
        this.fSourceContainers = null;
        this.fResolvedElements = null;
    }

    protected void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 125, message, exception);
        throw new CoreException(status);
    }

    private List<ISourceContainer> parseSourceContainers(NodeList list) throws CoreException {
        ArrayList<ISourceContainer> containers = new ArrayList<ISourceContainer>();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                ISourceContainerType type;
                Element element = (Element)list.item(i);
                String typeId = element.getAttribute(CONTAINER_TYPE_ATTR);
                if (typeId == null || typeId.equals("")) {
                    this.abort(SourceLookupMessages.AbstractSourceLookupDirector_11, null);
                }
                if ((type = DebugPlugin.getDefault().getLaunchManager().getSourceContainerType(typeId)) != null) {
                    String memento = element.getAttribute(CONTAINER_MEMENTO_ATTR);
                    if (memento == null || memento.equals("")) {
                        this.abort(SourceLookupMessages.AbstractSourceLookupDirector_13, null);
                    }
                    ISourceContainer container = type.createSourceContainer(memento);
                    containers.add(container);
                } else {
                    this.abort(MessageFormat.format(SourceLookupMessages.AbstractSourceLookupDirector_12, typeId), null);
                }
            }
            ++i;
        }
        return containers;
    }

    private synchronized void addSourceLookupParticipant(ISourceLookupParticipant participant) {
        if (!this.fParticipants.contains(participant)) {
            this.fParticipants.add(participant);
            participant.init(this);
        }
    }

    @Override
    public synchronized ISourceContainer[] getSourceContainers() {
        if (this.fSourceContainers == null) {
            return new ISourceContainer[0];
        }
        ISourceContainer[] copy = new ISourceContainer[this.fSourceContainers.length];
        System.arraycopy(this.fSourceContainers, 0, copy, 0, this.fSourceContainers.length);
        return copy;
    }

    @Override
    public boolean isFindDuplicates() {
        return this.fDuplicates;
    }

    @Override
    public void setFindDuplicates(boolean duplicates) {
        this.fDuplicates = duplicates;
    }

    private synchronized void removeSourceLookupParticipant(ISourceLookupParticipant participant) {
        if (this.fParticipants.remove(participant)) {
            participant.dispose();
        }
    }

    @Override
    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        ILaunchConfiguration from = DebugPlugin.getDefault().getLaunchManager().getMovedFrom(configuration);
        if (from != null && from.equals(this.getLaunchConfiguration())) {
            this.fConfig = configuration;
        }
    }

    @Override
    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        if (this.fConfig == null || configuration.isWorkingCopy()) {
            return;
        }
        if (this.fConfig.equals(configuration)) {
            try {
                String locatorMemento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, (String)null);
                if (locatorMemento == null) {
                    this.initializeDefaults(configuration);
                } else {
                    this.initializeFromMemento(locatorMemento, configuration);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    @Override
    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        if (configuration.equals(this.getLaunchConfiguration()) && DebugPlugin.getDefault().getLaunchManager().getMovedTo(configuration) == null) {
            this.fConfig = null;
        }
    }

    @Override
    public synchronized String getMemento() throws CoreException {
        Document doc = DebugPlugin.newDocument();
        Element rootNode = doc.createElement(DIRECTOR_ROOT_NODE);
        doc.appendChild(rootNode);
        Element pathNode = doc.createElement(CONTAINERS_NODE);
        if (this.fDuplicates) {
            pathNode.setAttribute(DUPLICATES_ATTR, "true");
        } else {
            pathNode.setAttribute(DUPLICATES_ATTR, "false");
        }
        rootNode.appendChild(pathNode);
        if (this.fSourceContainers != null) {
            ISourceContainer[] iSourceContainerArray = this.fSourceContainers;
            int n = this.fSourceContainers.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer container = iSourceContainerArray[n2];
                Element node = doc.createElement(CONTAINER_NODE);
                ISourceContainerType type = container.getType();
                node.setAttribute(CONTAINER_TYPE_ATTR, type.getId());
                node.setAttribute(CONTAINER_MEMENTO_ATTR, type.getMemento(container));
                pathNode.appendChild(node);
                ++n2;
            }
        }
        return DebugPlugin.serializeDocument(doc);
    }

    @Override
    public void initializeFromMemento(String memento) throws CoreException {
        this.doInitializeFromMemento(memento, true);
    }

    protected void doInitializeFromMemento(String memento, boolean dispose) throws CoreException {
        Element rootElement;
        if (dispose) {
            this.dispose();
        }
        if (!(rootElement = DebugPlugin.parseDocument(memento)).getNodeName().equalsIgnoreCase(DIRECTOR_ROOT_NODE)) {
            this.abort(SourceLookupMessages.AbstractSourceLookupDirector_14, null);
        }
        NodeList list = rootElement.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element entry;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(CONTAINERS_NODE)) {
                this.setFindDuplicates("true".equals(entry.getAttribute(DUPLICATES_ATTR)));
                NodeList children = entry.getChildNodes();
                List<ISourceContainer> containers = this.parseSourceContainers(children);
                this.setSourceContainers(containers.toArray(new ISourceContainer[containers.size()]));
            }
            ++i;
        }
        this.initializeParticipants();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSourceContainers(ISourceContainer[] containers) {
        ISourceLookupParticipant[] participants;
        AbstractSourceLookupDirector abstractSourceLookupDirector = this;
        synchronized (abstractSourceLookupDirector) {
            ISourceContainer container;
            ISourceContainer[] old;
            List<ISourceContainer> list = Arrays.asList(containers);
            ISourceContainer[] iSourceContainerArray = old = this.getSourceContainers();
            int n = old.length;
            int n2 = 0;
            while (n2 < n) {
                container = iSourceContainerArray[n2];
                if (!list.contains(container)) {
                    container.dispose();
                }
                ++n2;
            }
            this.fSourceContainers = containers;
            iSourceContainerArray = containers;
            n = containers.length;
            n2 = 0;
            while (n2 < n) {
                container = iSourceContainerArray[n2];
                container.init(this);
                ++n2;
            }
        }
        this.fResolvedElements = null;
        ISourceLookupParticipant[] iSourceLookupParticipantArray = participants = this.getParticipants();
        int n = participants.length;
        int n3 = 0;
        while (n3 < n) {
            ISourceLookupParticipant participant = iSourceLookupParticipantArray[n3];
            participant.sourceContainersChanged(this);
            ++n3;
        }
    }

    @Override
    public Object getSourceElement(IStackFrame stackFrame) {
        return this.getSourceElement((Object)stackFrame);
    }

    protected List<Object> doSourceLookup(Object element) {
        SourceLookupQuery query = new SourceLookupQuery(element);
        SafeRunner.run(query);
        List<Object> sources = query.getSourceElements();
        Throwable exception = query.getException();
        if (exception != null) {
            if (exception instanceof CoreException) {
                CoreException ce = (CoreException)exception;
                if (ce.getStatus().getSeverity() == 4) {
                    DebugPlugin.log(ce);
                }
            } else {
                DebugPlugin.log(exception);
            }
        }
        query.dispose();
        return sources;
    }

    public Object resolveSourceElement(Object element, List<Object> sources) {
        for (Object dup : sources) {
            Object resolved = this.getCachedElement(dup);
            if (resolved == null) continue;
            return resolved;
        }
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(fPromptStatus);
        if (prompter != null) {
            try {
                Object result = prompter.handleStatus(fResolveDuplicatesStatus, new Object[]{element, sources});
                if (result != null) {
                    this.cacheResolvedElement(sources, result);
                    return result;
                }
            }
            catch (CoreException coreException) {}
        }
        return sources.get(0);
    }

    private boolean checkDuplicate(Object sourceToAdd, List<Object> sources) {
        if (sources.isEmpty()) {
            return false;
        }
        for (Object obj : sources) {
            if (!this.equalSourceElements(obj, sourceToAdd)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initializeFromMemento(String memento, ILaunchConfiguration configuration) throws CoreException {
        this.dispose();
        this.setLaunchConfiguration(configuration);
        this.doInitializeFromMemento(memento, false);
    }

    @Override
    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.dispose();
        this.setLaunchConfiguration(configuration);
        this.setSourceContainers(new ISourceContainer[]{new DefaultSourceContainer()});
        this.initializeParticipants();
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration() {
        return this.fConfig;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.fConfig = configuration;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchConfigurationListener(this);
        launchManager.addLaunchListener(this);
    }

    @Override
    public void launchAdded(ILaunch launch) {
    }

    @Override
    public void launchChanged(ILaunch launch) {
    }

    @Override
    public void launchRemoved(ILaunch launch) {
        if (this.equals(launch.getSourceLocator())) {
            this.dispose();
        }
    }

    @Override
    public synchronized ISourceLookupParticipant[] getParticipants() {
        return this.fParticipants.toArray(new ISourceLookupParticipant[this.fParticipants.size()]);
    }

    @Override
    public boolean supportsSourceContainerType(ISourceContainerType type) {
        return true;
    }

    protected void cacheResolvedElement(List<Object> duplicates, Object sourceElement) {
        if (this.fResolvedElements == null) {
            this.fResolvedElements = new HashMap<Object, Object>(10);
        }
        for (Object dup : duplicates) {
            this.fResolvedElements.put(dup, sourceElement);
        }
    }

    protected Object getCachedElement(Object duplicate) {
        if (this.fResolvedElements != null) {
            return this.fResolvedElements.get(duplicate);
        }
        return null;
    }

    protected void clearCachedElement(Object duplicate) {
        if (this.fResolvedElements != null) {
            this.fResolvedElements.remove(duplicate);
        }
    }

    @Override
    public void clearSourceElements(Object element) {
        List<Object> list = this.doSourceLookup(element);
        if (list.size() > 0) {
            for (Object obj : list) {
                this.clearCachedElement(obj);
            }
        }
    }

    @Override
    public void addParticipants(ISourceLookupParticipant[] participants) {
        ISourceLookupParticipant[] iSourceLookupParticipantArray = participants;
        int n = participants.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceLookupParticipant participant = iSourceLookupParticipantArray[n2];
            this.addSourceLookupParticipant(participant);
            participant.sourceContainersChanged(this);
            ++n2;
        }
    }

    @Override
    public void removeParticipants(ISourceLookupParticipant[] participants) {
        ISourceLookupParticipant[] iSourceLookupParticipantArray = participants;
        int n = participants.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceLookupParticipant participant = iSourceLookupParticipantArray[n2];
            this.removeSourceLookupParticipant(participant);
            ++n2;
        }
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public ISourcePathComputer getSourcePathComputer() {
        if (this.fComputer == null && this.getLaunchConfiguration() != null) {
            try {
                return DebugPlugin.getDefault().getLaunchManager().getSourcePathComputer(this.getLaunchConfiguration());
            }
            catch (CoreException coreException) {}
        }
        return this.fComputer;
    }

    @Override
    public void setSourcePathComputer(ISourcePathComputer computer) {
        this.fComputer = computer;
    }

    @Override
    public Object[] findSourceElements(Object object) throws CoreException {
        SourceLookupQuery query = new SourceLookupQuery(object);
        SafeRunner.run(query);
        List<Object> sources = query.getSourceElements();
        Throwable exception = query.getException();
        query.dispose();
        if (exception != null && sources.isEmpty()) {
            if (exception instanceof CoreException) {
                throw (CoreException)exception;
            }
            this.abort(SourceLookupMessages.AbstractSourceLookupDirector_10, exception);
        }
        return sources.toArray();
    }

    @Override
    public Object getSourceElement(Object element) {
        List<Object> sources = this.doSourceLookup(element);
        if (sources.size() == 1) {
            return sources.get(0);
        }
        if (sources.size() > 1) {
            return this.resolveSourceElement(element, sources);
        }
        return null;
    }

    private void setCurrentParticipant(ISourceLookupParticipant participant) {
        this.fCurrentParticipant = participant;
    }

    public ISourceLookupParticipant getCurrentParticipant() {
        return this.fCurrentParticipant;
    }

    class SourceLookupQuery
    implements ISafeRunnable {
        private List<Object> fSourceElements = new ArrayList<Object>();
        private Object fElement = null;
        private Throwable fException = null;

        SourceLookupQuery(Object element) {
            this.fElement = element;
        }

        @Override
        public void handleException(Throwable exception) {
            this.fException = exception;
        }

        public Throwable getException() {
            return this.fException;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() throws Exception {
            multiStatus = null;
            single = null;
            participants = AbstractSourceLookupDirector.this.getParticipants();
            try {
                var7_4 = participants;
                var6_5 = participants.length;
                var5_6 = 0;
                while (var5_6 < var6_5) {
                    participant = var7_4[var5_6];
                    AbstractSourceLookupDirector.this.setCurrentParticipant(participant);
                    try {
                        block18: {
                            sourceArray = participant.findSourceElements(this.fElement);
                            if (sourceArray == null || sourceArray.length <= 0) ** GOTO lbl40
                            if (!AbstractSourceLookupDirector.this.isFindDuplicates()) break block18;
                            var12_13 = sourceArray;
                            var11_12 = sourceArray.length;
                            var10_11 = 0;
                            while (var10_11 < var11_12) {
                                s = var12_13[var10_11];
                                if (!AbstractSourceLookupDirector.this.checkDuplicate(s, this.fSourceElements)) {
                                    this.fSourceElements.add(s);
                                }
                                ++var10_11;
                            }
                            ** GOTO lbl40
                        }
                        this.fSourceElements.add(sourceArray[0]);
                        return;
                    }
                    catch (CoreException e) {
                        if (single == null) {
                            single = e;
                        } else if (multiStatus == null) {
                            multiStatus = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 125, new IStatus[]{single.getStatus()}, SourceLookupMessages.Source_Lookup_Error, null);
                            multiStatus.add(e.getStatus());
                        } else {
                            multiStatus.add(e.getStatus());
                        }
lbl40:
                        // 5 sources

                        ++var5_6;
                    }
                }
            }
            finally {
                AbstractSourceLookupDirector.this.setCurrentParticipant(null);
            }
            if (this.fSourceElements.isEmpty()) {
                if (multiStatus != null) {
                    this.fException = new CoreException(multiStatus);
                } else if (single != null) {
                    this.fException = single;
                }
            }
        }

        public List<Object> getSourceElements() {
            return this.fSourceElements;
        }

        public void dispose() {
            this.fElement = null;
            this.fSourceElements = null;
            this.fException = null;
        }
    }
}

