/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.model;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ITriggerPoint;
import org.eclipse.debug.internal.core.BreakpointManager;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public abstract class Breakpoint
extends PlatformObject
implements IBreakpoint,
ITriggerPoint {
    private IMarker fMarker = null;

    public Breakpoint() {
        ((BreakpointManager)DebugPlugin.getDefault().getBreakpointManager()).ensureInitialized();
    }

    @Override
    public void setMarker(IMarker marker) throws CoreException {
        this.fMarker = marker;
    }

    public boolean equals(Object item) {
        if (item instanceof IBreakpoint) {
            return this.getMarker().equals(((IBreakpoint)item).getMarker());
        }
        return false;
    }

    public int hashCode() {
        return this.getMarker().hashCode();
    }

    @Override
    public void setEnabled(boolean enabled) throws CoreException {
        if (enabled != this.isEnabled()) {
            this.setAttribute("org.eclipse.debug.core.enabled", enabled);
            if (this.isTriggerPoint()) {
                DebugPlugin.getDefault().getBreakpointManager().refreshTriggerpointDisplay();
            }
        }
    }

    @Override
    public boolean isEnabled() throws CoreException {
        return this.getMarker().getAttribute("org.eclipse.debug.core.enabled", false);
    }

    @Override
    public boolean isRegistered() throws CoreException {
        IMarker marker = this.getMarker();
        return marker.exists() && marker.getAttribute("org.eclipse.debug.core.registered", true);
    }

    @Override
    public void setRegistered(boolean registered) throws CoreException {
        if (this.isRegistered() != registered) {
            this.setAttribute("org.eclipse.debug.core.registered", registered);
            IBreakpointManager mgr = DebugPlugin.getDefault().getBreakpointManager();
            if (registered) {
                mgr.addBreakpoint(this);
            } else {
                mgr.removeBreakpoint(this, false);
            }
        }
    }

    @Override
    public void delete() throws CoreException {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(this, false);
        this.getMarker().delete();
    }

    @Override
    public IMarker getMarker() {
        return this.fMarker;
    }

    @Override
    public boolean isPersisted() throws CoreException {
        return this.getMarker().getAttribute("org.eclipse.debug.core.persisted", true);
    }

    @Override
    public void setPersisted(boolean persisted) throws CoreException {
        if (this.isPersisted() != persisted) {
            this.setAttributes(new String[]{"org.eclipse.debug.core.persisted", "transient"}, new Object[]{persisted, !persisted});
        }
    }

    @Override
    public boolean isTriggerPoint() throws CoreException {
        return this.getMarker().getAttribute("org.eclipse.debug.core.triggerpoint", false);
    }

    @Override
    public void setTriggerPoint(boolean triggerPoint) throws CoreException {
        if (this.isTriggerPoint() != triggerPoint) {
            this.setAttribute("org.eclipse.debug.core.triggerpoint", triggerPoint);
            IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
            if (triggerPoint) {
                manager.addTriggerPoint(this);
            } else {
                manager.removeTriggerPoint(this);
            }
        }
    }

    protected void setAttribute(String attributeName, boolean value) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = monitor -> this.ensureMarker().setAttribute(attributeName, value);
        workspace.run(runnable, this.getMarkerRule(), 1, null);
    }

    protected void setAttribute(String attributeName, int value) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = monitor -> this.ensureMarker().setAttribute(attributeName, value);
        workspace.run(runnable, this.getMarkerRule(), 1, null);
    }

    protected void setAttribute(String attributeName, Object value) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = monitor -> this.ensureMarker().setAttribute(attributeName, value);
        workspace.run(runnable, this.getMarkerRule(), 1, null);
    }

    protected void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = monitor -> this.ensureMarker().setAttributes(attributeNames, values);
        workspace.run(runnable, this.getMarkerRule(), 1, null);
    }

    protected void setAttributes(Map<String, ? extends Object> attributes) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = monitor -> this.ensureMarker().setAttributes(attributes);
        workspace.run(runnable, this.getMarkerRule(), 1, null);
    }

    protected IMarker ensureMarker() throws DebugException {
        IMarker m = this.getMarker();
        if (m == null || !m.exists()) {
            throw new DebugException(new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.Breakpoint_no_associated_marker, null));
        }
        return m;
    }

    protected boolean markerExists() {
        IMarker m = this.getMarker();
        return m != null && m.exists();
    }

    protected ISchedulingRule getMarkerRule(IResource resource) {
        ISchedulingRule rule = null;
        if (resource != null) {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            rule = ruleFactory.markerRule(resource);
        }
        return rule;
    }

    protected ISchedulingRule getMarkerRule() {
        IResource resource;
        ISchedulingRule rule = null;
        IMarker marker = this.getMarker();
        if (marker != null && (resource = marker.getResource()) != null) {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            rule = ruleFactory.markerRule(resource);
        }
        return rule;
    }

    protected void run(ISchedulingRule rule, IWorkspaceRunnable wr) throws DebugException {
        try {
            ResourcesPlugin.getWorkspace().run(wr, rule, 1, null);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" on [");
        if (this.fMarker != null) {
            builder.append("marker=");
            builder.append(this.fMarker);
        }
        builder.append("]");
        return builder.toString();
    }
}

