/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerDelta;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerReader;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class MarkerReader_1
extends MarkerReader {
    public static final int INDEX = 1;
    public static final int QNAME = 2;
    public static final int ATTRIBUTE_NULL = -1;
    public static final int ATTRIBUTE_BOOLEAN = 0;
    public static final int ATTRIBUTE_INTEGER = 1;
    public static final int ATTRIBUTE_STRING = 2;

    public MarkerReader_1(Workspace workspace) {
        super(workspace);
    }

    @Override
    public void read(DataInputStream input, boolean generateDeltas) throws IOException, CoreException {
        try {
            ArrayList<String> readTypes = new ArrayList<String>(5);
            while (true) {
                Path path = new Path(input.readUTF());
                int markersSize = input.readInt();
                MarkerSet markers = new MarkerSet(markersSize);
                int i = 0;
                while (i < markersSize) {
                    markers.add(this.readMarkerInfo(input, readTypes));
                    ++i;
                }
                ResourceInfo info = this.workspace.getResourceInfo(path, false, false);
                if (info == null) continue;
                info.setMarkers(markers);
                if (!generateDeltas) continue;
                Resource resource = this.workspace.newResource(path, info.getType());
                IMarkerSetElement[] infos = markers.elements;
                ArrayList<MarkerDelta> deltas = new ArrayList<MarkerDelta>(infos.length);
                IMarkerSetElement[] iMarkerSetElementArray = infos;
                int n = infos.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkerSetElement info2 = iMarkerSetElementArray[n2];
                    if (info2 != null) {
                        deltas.add(new MarkerDelta(1, resource, (MarkerInfo)info2));
                    }
                    ++n2;
                }
                this.workspace.getMarkerManager().changedMarkers(resource, deltas.toArray(new IMarkerSetElement[deltas.size()]));
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private Map<String, Object> readAttributes(DataInputStream input) throws IOException {
        int attributesSize = input.readInt();
        if (attributesSize == 0) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(attributesSize);
        int j = 0;
        while (j < attributesSize) {
            String key = input.readUTF();
            int type = input.readInt();
            Object value = null;
            switch (type) {
                case 1: {
                    value = input.readInt();
                    break;
                }
                case 0: {
                    value = input.readBoolean();
                    break;
                }
                case 2: {
                    value = input.readUTF();
                    break;
                }
            }
            if (value != null) {
                result.put(key, value);
            }
            ++j;
        }
        return result.isEmpty() ? null : result;
    }

    private MarkerInfo readMarkerInfo(DataInputStream input, List<String> readTypes) throws IOException, CoreException {
        long id = input.readLong();
        int constant = input.readInt();
        String type = null;
        switch (constant) {
            case 2: {
                type = input.readUTF();
                readTypes.add(type);
                break;
            }
            case 1: {
                type = readTypes.get(input.readInt());
                break;
            }
            default: {
                String msg = Messages.resources_readMarkers;
                throw new ResourceException(567, null, msg, null);
            }
        }
        Map<String, Object> map = this.readAttributes(input);
        long creationTime = 0L;
        return new MarkerInfo(map, false, creationTime, type, id);
    }
}

