/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class AliasManager
implements IManager,
ILifecycleListener,
IResourceChangeListener {
    protected final Set<IResource> aliasedProjects = new HashSet<IResource>();
    protected final HashSet<IResource> aliases = new HashSet();
    private final Set<IResource> changedLinks = ConcurrentHashMap.newKeySet();
    private volatile boolean changedProjects = false;
    protected final LocationMap locationsMap = new LocationMap();
    private int nonDefaultResourceCount = 0;
    public IPath suffix;
    protected final Workspace workspace;

    public AliasManager(Workspace workspace) {
        this.workspace = workspace;
    }

    private void addToLocationsMap(IProject project) {
        HashMap<IPath, LinkDescription> links;
        ProjectDescription description;
        IFileStore location = ((Resource)((Object)project)).getStore();
        if (location != null) {
            this.locationsMap.add(location, project);
        }
        if ((description = ((Project)project).internalGetDescription()) == null) {
            return;
        }
        if (description.getLocationURI() != null) {
            ++this.nonDefaultResourceCount;
        }
        if ((links = description.getLinks()) == null) {
            return;
        }
        for (LinkDescription linkDesc : links.values()) {
            IResource link = project.findMember(linkDesc.getProjectRelativePath());
            if (link == null) continue;
            try {
                URI locationURI = linkDesc.getLocationURI();
                locationURI = FileUtil.canonicalURI(locationURI);
                locationURI = link.getPathVariableManager().resolveURI(locationURI);
                this.addToLocationsMap(link, EFS.getStore(locationURI));
            }
            catch (CoreException coreException) {}
        }
    }

    private void addToLocationsMap(IResource link, IFileStore location) {
        if (location != null && !link.isVirtual() && this.locationsMap.add(location, link)) {
            ++this.nonDefaultResourceCount;
        }
    }

    private void buildAliasedProjectsSet() {
        this.aliasedProjects.clear();
        if (this.nonDefaultResourceCount <= 0) {
            return;
        }
        this.locationsMap.overLappingResourcesDo(this.aliasedProjects::add);
    }

    private void buildLocationsMap() {
        IProject[] projects;
        this.locationsMap.clear();
        this.nonDefaultResourceCount = 0;
        IProject[] iProjectArray = projects = this.workspace.getRoot().getProjects(8);
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                this.addToLocationsMap(project);
            }
            ++n2;
        }
    }

    private boolean checkDeletion(Project project, IFileStore location) throws CoreException {
        if (project.exists() && !location.fetchInfo().exists()) {
            Assert.isTrue(this.workspace.getWorkManager().getLock().getDepth() > 0);
            project.deleteResource(false, null);
            return true;
        }
        return false;
    }

    public IResource[] computeAliases(IResource resource, IFileStore location) {
        if (this.hasNoAliases(resource)) {
            return null;
        }
        this.aliases.clear();
        this.internalComputeAliases(resource, location);
        int size = this.aliases.size();
        if (size == 0) {
            return null;
        }
        return this.aliases.toArray(new IResource[size]);
    }

    public IResource[] findResources(IFileStore location) {
        ArrayList resources = new ArrayList();
        this.locationsMap.matchingResourcesDo(location, resource -> {
            boolean bl = resources.add(resource);
        });
        return resources.toArray(new IResource[0]);
    }

    private void computeDeepAliases(IResource resource, IFileStore location) {
        if (location == null) {
            return;
        }
        this.internalComputeAliases(resource, location);
        this.locationsMap.matchingPrefixDo(location, this.aliases::add);
        if (resource.getType() == 4) {
            try {
                IResource[] members = ((IProject)resource).members();
                FileSystemResourceManager localManager = this.workspace.getFileSystemManager();
                IResource[] iResourceArray = members;
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileStore linkLocation;
                    IResource member = iResourceArray[n2];
                    if (member.isLinked() && (linkLocation = localManager.getStore(member)) != null) {
                        this.locationsMap.matchingPrefixDo(linkLocation, this.aliases::add);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    @Override
    public void handleEvent(LifecycleEvent event) {
        switch (event.kind) {
            case 1024: 
            case 524288: {
                Resource link = (Resource)event.resource;
                if (link.isLinked()) {
                    this.removeFromLocationsMap(link, link.getStore());
                }
            }
            case 512: 
            case 131072: 
            case 262144: {
                this.changedLinks.add(event.resource);
                break;
            }
            case 256: {
                this.changedLinks.add(event.newResource);
                break;
            }
            case 2048: {
                Resource link = (Resource)event.resource;
                if (link.isLinked()) {
                    this.removeFromLocationsMap(link, link.getStore());
                }
                this.changedLinks.add(event.newResource);
            }
        }
    }

    private boolean hasNoAliases(IResource resource) {
        boolean noAliases;
        IProject project = resource.getProject();
        boolean bl = noAliases = !this.aliasedProjects.contains(project);
        if (this.checkStructuralChanges()) {
            noAliases &= this.nonDefaultResourceCount <= 0 || !this.aliasedProjects.contains(project);
        }
        return noAliases;
    }

    private void internalComputeAliases(IResource resource, IFileStore location) {
        IFileStore searchLocation = location;
        if (searchLocation == null) {
            searchLocation = ((Resource)resource).getStore();
        }
        if (searchLocation == null) {
            return;
        }
        this.suffix = Path.EMPTY;
        FindAliasesDoit findAliases = new FindAliasesDoit(resource);
        do {
            this.locationsMap.matchingResourcesDo(searchLocation, findAliases);
            this.suffix = new Path(searchLocation.getName()).append(this.suffix);
        } while ((searchLocation = searchLocation.getParent()) != null);
    }

    private void removeFromLocationsMap(IResource link, IFileStore location) {
        if (location != null && this.locationsMap.remove(location, link)) {
            --this.nonDefaultResourceCount;
        }
    }

    @Override
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] changed;
        if (this.changedProjects) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        if (delta.getAffectedChildren(3, 8).length > 0) {
            this.changedProjects = true;
            return;
        }
        IResourceDelta[] iResourceDeltaArray = changed = delta.getAffectedChildren(4, 8);
        int n = changed.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta element = iResourceDeltaArray[n2];
            if ((element.getFlags() & 0x80000) == 524288 || (element.getFlags() & 0x4000) == 16384) {
                this.changedProjects = true;
                return;
            }
            ++n2;
        }
    }

    @Override
    public void shutdown(IProgressMonitor monitor) {
        this.workspace.removeResourceChangeListener(this);
        this.locationsMap.clear();
    }

    @Override
    public void startup(IProgressMonitor monitor) {
        this.workspace.addLifecycleListener(this);
        this.workspace.addResourceChangeListener(this, 1);
        this.buildLocationsMap();
        this.buildAliasedProjectsSet();
    }

    public void updateAliases(IResource resource, IFileStore location, int depth, IProgressMonitor monitor) throws CoreException {
        if (this.hasNoAliases(resource)) {
            return;
        }
        this.aliases.clear();
        if (depth == 0) {
            this.internalComputeAliases(resource, location);
        } else {
            this.computeDeepAliases(resource, location);
        }
        if (this.aliases.isEmpty()) {
            return;
        }
        FileSystemResourceManager localManager = this.workspace.getFileSystemManager();
        HashSet aliasesCopy = (HashSet)this.aliases.clone();
        for (IResource alias : aliasesCopy) {
            monitor.subTask(NLS.bind(Messages.links_updatingDuplicate, alias.getFullPath()));
            if (alias.getType() == 4 && this.checkDeletion((Project)alias, location) || ((Resource)alias).isFiltered()) continue;
            localManager.refresh(alias, 2, false, null);
        }
    }

    private synchronized boolean checkStructuralChanges() {
        boolean hadChanges = false;
        if (this.changedProjects) {
            this.changedProjects = false;
            this.changedLinks.clear();
            hadChanges = true;
            this.buildLocationsMap();
        } else {
            HashSet<IResource> changedLinksSnapshots = new HashSet<IResource>(this.changedLinks);
            this.changedLinks.removeAll(changedLinksSnapshots);
            hadChanges = !changedLinksSnapshots.isEmpty();
            for (IResource resource : changedLinksSnapshots) {
                if (!resource.isAccessible() || !resource.isLinked()) continue;
                this.addToLocationsMap(resource, ((Resource)resource).getStore());
            }
        }
        if (hadChanges) {
            this.buildAliasedProjectsSet();
        }
        return hadChanges;
    }

    class FindAliasesDoit
    implements Consumer<IResource> {
        private final int aliasType;
        private final IPath searchPath;

        public FindAliasesDoit(IResource aliasResource) {
            this.aliasType = aliasResource.getType();
            this.searchPath = aliasResource.getFullPath();
        }

        @Override
        public void accept(IResource match) {
            if (match.getFullPath().isPrefixOf(this.searchPath)) {
                return;
            }
            IPath aliasPath = null;
            switch (match.getType()) {
                case 4: {
                    IResource testResource;
                    if (AliasManager.this.suffix.segmentCount() > 0 && (testResource = ((IProject)match).findMember(AliasManager.this.suffix.segment(0))) != null && testResource.isLinked()) {
                        return;
                    }
                    aliasPath = match.getFullPath().append(AliasManager.this.suffix);
                    break;
                }
                case 2: {
                    aliasPath = match.getFullPath().append(AliasManager.this.suffix);
                    break;
                }
                case 1: {
                    if (AliasManager.this.suffix.segmentCount() != 0) break;
                    aliasPath = match.getFullPath();
                }
            }
            if (aliasPath != null) {
                if (this.aliasType == 1) {
                    AliasManager.this.aliases.add(AliasManager.this.workspace.getRoot().getFile(aliasPath));
                } else if (aliasPath.segmentCount() == 1) {
                    AliasManager.this.aliases.add(AliasManager.this.workspace.getRoot().getProject(aliasPath.lastSegment()));
                } else {
                    AliasManager.this.aliases.add(AliasManager.this.workspace.getRoot().getFolder(aliasPath));
                }
            }
        }
    }

    class LocationMap {
        private final SortedMap<IFileStore, Object> map = new TreeMap<IFileStore, Object>(IFileStore::compareTo);

        LocationMap() {
        }

        public boolean add(IFileStore location, IResource resource) {
            Object oldValue = this.map.get(location);
            if (oldValue == null) {
                this.map.put(location, resource);
                return true;
            }
            if (oldValue instanceof IResource) {
                if (resource.equals(oldValue)) {
                    return false;
                }
                ArrayList<Object> newValue = new ArrayList<Object>(2);
                newValue.add(oldValue);
                newValue.add(resource);
                this.map.put(location, newValue);
                return true;
            }
            ArrayList list = (ArrayList)oldValue;
            if (list.contains(resource)) {
                return false;
            }
            list.add(resource);
            return true;
        }

        public void clear() {
            this.map.clear();
        }

        public void matchingPrefixDo(IFileStore prefix, Consumer<IResource> doit) {
            SortedMap<IFileStore, Object> matching;
            IFileStore prefixParent = prefix.getParent();
            if (prefixParent != null) {
                IFileStore endPoint = prefixParent.getChild(String.valueOf(prefix.getName()) + "\u0000");
                matching = this.map.subMap(prefix, endPoint);
            } else {
                matching = this.map;
            }
            for (Object value : matching.values()) {
                if (value == null) {
                    return;
                }
                if (value instanceof List) {
                    for (Object element : (List)value) {
                        if (!(element instanceof IResource)) continue;
                        doit.accept((IResource)element);
                    }
                    continue;
                }
                doit.accept((IResource)value);
            }
        }

        public void matchingResourcesDo(IFileStore location, Consumer<IResource> doit) {
            Object value = this.map.get(location);
            if (value == null) {
                return;
            }
            if (value instanceof List) {
                for (Object element : (List)value) {
                    if (!(element instanceof IResource)) continue;
                    doit.accept((IResource)element);
                }
            } else {
                doit.accept((IResource)value);
            }
        }

        public void overLappingResourcesDo(Consumer<IResource> doit) {
            IFileStore previousStore = null;
            IResource previousResource = null;
            for (Map.Entry<IFileStore, Object> current : this.map.entrySet()) {
                IFileStore currentStore = current.getKey();
                IResource currentResource = null;
                Object value = current.getValue();
                if (value instanceof List) {
                    for (Object element : (List)value) {
                        if (!(element instanceof IResource)) continue;
                        doit.accept(((IResource)element).getProject());
                    }
                } else {
                    currentResource = (IResource)value;
                }
                if (previousStore != null && previousStore.isParentOf(currentStore)) {
                    if (previousResource != null) {
                        doit.accept(previousResource.getProject());
                        previousResource = null;
                    }
                    if (currentResource == null) continue;
                    doit.accept(currentResource.getProject());
                    continue;
                }
                previousStore = currentStore;
                previousResource = currentResource;
            }
        }

        public boolean remove(IFileStore location, IResource resource) {
            Object oldValue = this.map.get(location);
            if (oldValue == null) {
                return false;
            }
            if (oldValue instanceof IResource) {
                if (resource.equals(oldValue)) {
                    this.map.remove(location);
                    return true;
                }
                return false;
            }
            ArrayList list = (ArrayList)oldValue;
            boolean wasRemoved = list.remove(resource);
            if (list.isEmpty()) {
                this.map.remove(location);
            }
            return wasRemoved;
        }
    }
}

