/*
 * Decompiled with CFR 0.152.
 */
package de.fspengler.hudson.pview;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormValidation;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PViewProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private String regex;
        private String treeSplitChar;

        public DescriptorImpl() {
            super(PViewProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return false;
        }

        public String getDisplayName() {
            return "Filtered View";
        }

        public PViewProjectProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new PViewProjectProperty();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.regex = req.getParameter("pView.regex");
            this.treeSplitChar = req.getParameter("pView.treeSplitChar");
            this.save();
            return true;
        }

        public String getRegex() {
            if (this.regex == null) {
                return ".*";
            }
            return this.regex;
        }

        @Exported
        public String getTreeSplitChar() {
            this.checkEmptyTreeChar();
            return this.treeSplitChar;
        }

        public void setTreeSplitChar(String treeSplitChar) {
            this.treeSplitChar = treeSplitChar;
        }

        private void checkEmptyTreeChar() {
            if (this.treeSplitChar == null || this.treeSplitChar.length() == 0) {
                this.treeSplitChar = "-";
            }
        }

        public FormValidation doRegexCheck(@QueryParameter String value) {
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.error((String)"No regex");
            }
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)"Pattern cannot be compiled");
            }
        }
    }
}

