/*
 * Decompiled with CFR 0.152.
 */
package de.fspengler.hudson.pview;

import de.fspengler.hudson.pview.ConsoleViewColumn;
import de.fspengler.hudson.pview.DirEntry;
import de.fspengler.hudson.pview.PViewProjectProperty;
import de.fspengler.hudson.pview.UserPersonalViewProperty;
import hudson.FeedAdapter;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.RSS;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.util.RunList;
import hudson.views.BuildButtonColumn;
import hudson.views.JobColumn;
import hudson.views.LastDurationColumn;
import hudson.views.LastFailureColumn;
import hudson.views.LastStableColumn;
import hudson.views.LastSuccessColumn;
import hudson.views.ListViewColumn;
import hudson.views.StatusColumn;
import hudson.views.WeatherColumn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
public class PViewLinkAction
implements Action,
AccessControlled {
    private static final String URL_PART_SI_VIEW = "siView";
    private static final String URL_PART_ROOT_SI_VIEW = "rootSiView";
    private static final String P_URL_PVIEW_ROOT_SI_VIEW = "/pview/rootSiView";
    private static final String P_URL_PVIEW_SI_VIEW = "/pview/siView";
    private static final long serialVersionUID = 1L;

    public String getDisplayName() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null && req.getOriginalRequestURI().contains("/view")) {
            return null;
        }
        if (req.getAttribute("rootisSet") != null) {
            if (req.getAttribute("rootProject") != null) {
                return "Tree View: " + req.getAttribute("rootProject");
            }
            return "Tree View";
        }
        if (User.current() != null) {
            req.setAttribute("rootisSet", (Object)Boolean.TRUE);
            return "Personal View";
        }
        return "Anonymous View";
    }

    public String getUrlName() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null && req.getOriginalRequestURI().contains("/view")) {
            return null;
        }
        return "pview";
    }

    public String getIconFileName() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null && req.getOriginalRequestURI().contains("/view")) {
            return null;
        }
        return "up.gif";
    }

    private boolean isIsTreePosition(int position, boolean pDefault) {
        if (!this.isIsTree()) {
            return false;
        }
        if (this.getUser() && this.getUserProp() != null) {
            return this.getUserProp().getTreePosition() == position;
        }
        return pDefault;
    }

    public boolean isIsTreeNE() {
        return this.isIsTreePosition(0, true);
    }

    public boolean isIsTreeSE() {
        return this.isIsTreePosition(1, false);
    }

    public boolean isIsTreeNW() {
        return this.isIsTreePosition(2, false);
    }

    public boolean isIsTreeSW() {
        return this.isIsTreePosition(3, false);
    }

    public boolean isIsTree() {
        StaplerRequest req = Stapler.getCurrentRequest();
        return req != null && (req.getOriginalRequestURI().startsWith(this.getStepInViewUrl(req)) || req.getOriginalRequestURI().startsWith(this.getStepInViewRoot(req)));
    }

    private String getStepInViewRoot(StaplerRequest req) {
        return req.getContextPath() + P_URL_PVIEW_ROOT_SI_VIEW;
    }

    private String getStepInViewUrl(StaplerRequest req) {
        return req.getContextPath() + P_URL_PVIEW_SI_VIEW;
    }

    public boolean isIsList() {
        return !this.isIsTree();
    }

    public String getUserLogin() {
        if (this.getUser()) {
            return User.current().getUrl();
        }
        return "";
    }

    public boolean isHasUp() {
        if (this.isIsTree()) {
            return this.getProjectMatcher().length() > 0;
        }
        return false;
    }

    public String getTreeParent() {
        String result;
        if (this.isIsTree()) {
            String matcher = this.getProjectMatcher();
            String splitChar = "-";
            if (this.getUserProp() != null) {
                splitChar = this.getUserProp().getTreeSplitChar();
            }
            result = matcher.indexOf(splitChar) > -1 ? "siView/" + matcher.substring(0, matcher.lastIndexOf(splitChar)) + "/" : URL_PART_ROOT_SI_VIEW;
        } else {
            result = "";
        }
        return result;
    }

    public Collection<DirEntry> getSubDirs() {
        String splitChar = "-";
        if (this.getUserProp() != null) {
            splitChar = this.getUserProp().getTreeSplitChar();
        }
        List iList = Hudson.getInstance().getItems(AbstractProject.class);
        TreeMap<String, DirEntry> dirSet = new TreeMap<String, DirEntry>();
        String startMatcher = this.getProjectMatcher();
        int lenMatcher = startMatcher.length();
        Pattern pat = this.getFreePattern(Stapler.getCurrentRequest());
        if (lenMatcher > 0) {
            for (AbstractProject abstractProject : iList) {
                int posOfMatcher;
                if (pat != null && !pat.matcher(abstractProject.getName()).matches() || !abstractProject.getName().startsWith(startMatcher) || (posOfMatcher = abstractProject.getName().indexOf(splitChar, lenMatcher + 1)) <= -1) continue;
                String abString = abstractProject.getName().substring(lenMatcher + 1, posOfMatcher);
                if (dirSet.containsKey(abString)) {
                    ((DirEntry)dirSet.get(abString)).addOne();
                    continue;
                }
                DirEntry de = new DirEntry(abString, startMatcher + splitChar + abString);
                dirSet.put(abString, de);
            }
        } else {
            for (AbstractProject abstractProject : iList) {
                int posOfMatcher = abstractProject.getName().indexOf(splitChar);
                if (posOfMatcher <= -1) continue;
                String abString = abstractProject.getName().substring(0, posOfMatcher);
                if (dirSet.containsKey(abString)) {
                    ((DirEntry)dirSet.get(abString)).addOne();
                    continue;
                }
                DirEntry de = new DirEntry(abString, abString);
                dirSet.put(abString, de);
            }
        }
        return dirSet.values();
    }

    public List<AbstractProject> getJobs() {
        return this.getJobs(null, null);
    }

    public List<AbstractProject> getJobs(StaplerRequest req, StaplerResponse rsp) {
        StaplerRequest mReq = req == null ? Stapler.getCurrentRequest() : req;
        ArrayList<AbstractProject> jobList = new ArrayList<AbstractProject>();
        List iList = Hudson.getInstance().getItems(AbstractProject.class);
        String splitChar = "-";
        if (this.getUserProp() != null) {
            splitChar = this.getUserProp().getTreeSplitChar();
        }
        if (this.isIsTree()) {
            if (mReq.getOriginalRequestURI().startsWith(this.getStepInViewRoot(mReq))) {
                Pattern pat = this.getFreePattern(mReq);
                if (pat != null && !pat.pattern().equals(".*")) {
                    for (AbstractProject abstractProject : iList) {
                        if (!pat.matcher(abstractProject.getName()).matches()) continue;
                        jobList.add(abstractProject);
                    }
                } else {
                    for (AbstractProject abstractProject : iList) {
                        if (abstractProject.getName().contains(splitChar)) continue;
                        jobList.add(abstractProject);
                    }
                }
            } else {
                String startMatcher = this.getProjectMatcher(mReq);
                Pattern pat = this.getFreePattern(mReq);
                for (AbstractProject abstractProject : iList) {
                    if (!abstractProject.getName().startsWith(startMatcher)) continue;
                    if (pat != null) {
                        if (pat.matcher(abstractProject.getName()).matches()) {
                            jobList.add(abstractProject);
                        }
                    } else {
                        jobList.add(abstractProject);
                    }
                    int stepInNumberJobs = 30;
                    if (this.getUserProp() != null) {
                        stepInNumberJobs = this.getUserProp().getStepInNumberJobs();
                    }
                    if (jobList.size() <= stepInNumberJobs) continue;
                    jobList.clear();
                    break;
                }
            }
        } else {
            Pattern pat = this.getUserPattern(mReq);
            for (AbstractProject abstractProject : iList) {
                if (!pat.matcher(abstractProject.getName()).matches()) continue;
                jobList.add(abstractProject);
            }
        }
        return jobList;
    }

    private Pattern getFreePattern(StaplerRequest req) {
        Pattern pat = null;
        if (req.hasParameter("match") && req.getParameter("match").length() > 0) {
            pat = Pattern.compile(req.getParameter("match"));
        }
        return pat;
    }

    public String getNicePattern() {
        Pattern pat = this.getFreePattern(Stapler.getCurrentRequest());
        if (pat != null) {
            return pat.pattern();
        }
        return ".*";
    }

    public String getNiceUserPattern() {
        Pattern pat = this.getUserPattern(Stapler.getCurrentRequest());
        if (pat != null) {
            return pat.pattern();
        }
        return ".*";
    }

    public String getProjectMatcher() {
        return this.getProjectMatcher(Stapler.getCurrentRequest());
    }

    public String getProjectMatcher(StaplerRequest req) {
        String orgUri = req.getOriginalRequestURI();
        if (orgUri.substring(orgUri.lastIndexOf("/")).startsWith("/rss")) {
            orgUri = orgUri.substring(0, orgUri.lastIndexOf("/") + 1);
        }
        if (!orgUri.startsWith(this.getStepInViewUrl(req) + "/")) {
            return "";
        }
        String matchPoint = orgUri.substring((this.getStepInViewUrl(req) + "/").length(), orgUri.length() - 1);
        return matchPoint;
    }

    private Pattern getUserPattern(StaplerRequest req) {
        Pattern pat = this.getFreePattern(req);
        if (pat != null) {
            return pat;
        }
        UserPersonalViewProperty up = this.getUserProp();
        pat = up != null ? Pattern.compile(this.getUserProp().getPViewExpression()) : Pattern.compile(PViewProjectProperty.DESCRIPTOR.getRegex());
        return pat;
    }

    public boolean getShowQueue() {
        if (this.getUserProp() == null) {
            return true;
        }
        return !this.getUserProp().isPViewBuildNoQueue();
    }

    public boolean getShowExecutor() {
        if (this.getUserProp() == null) {
            return true;
        }
        return !this.getUserProp().isPViewBuildNoExecutor();
    }

    private UserPersonalViewProperty getUserProp() {
        if (User.current() != null) {
            return (UserPersonalViewProperty)User.current().getProperty(UserPersonalViewProperty.class);
        }
        return null;
    }

    public boolean getUser() {
        return User.current() != null;
    }

    public ACL getACL() {
        return Hudson.getInstance().getACL();
    }

    public void checkPermission(Permission p) {
        this.getACL().checkPermission(p);
    }

    public boolean hasPermission(Permission p) {
        return User.current() != null;
    }

    public void doRssAll(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.rss(req, rsp, " all builds", this.getBuilds(req, rsp));
    }

    public void doRssFailed(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.rss(req, rsp, " failed builds", this.getBuilds(req, rsp).failureOnly());
    }

    public RunList getBuilds() {
        return this.getBuilds(null, null);
    }

    private RunList getBuilds(StaplerRequest req, StaplerResponse rsp) {
        return new RunList(this.getJobs(req, rsp));
    }

    private void rss(StaplerRequest req, StaplerResponse rsp, String suffix, RunList runs) throws IOException, ServletException {
        RSS.forwardToRss((String)(this.getDisplayName() + suffix), (String)this.getUrlName(), (Collection)runs.newBuilds(), (FeedAdapter)Run.FEED_ADAPTER, (StaplerRequest)req, (HttpServletResponse)rsp);
    }

    public void doRssLatest(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        ArrayList<Run> lastBuilds = new ArrayList<Run>();
        List<AbstractProject> list = this.getJobs(req, rsp);
        for (AbstractProject project : list) {
            Run lb = project.getLastBuild();
            if (lb == null) continue;
            lastBuilds.add(lb);
        }
        RSS.forwardToRss((String)(this.getDisplayName() + " last builds only"), (String)this.getUrlName(), lastBuilds, (FeedAdapter)Run.FEED_ADAPTER_LATEST, (StaplerRequest)req, (HttpServletResponse)rsp);
    }

    public final TopLevelItem getJob(String name) {
        return Hudson.getInstance().getItem(name);
    }

    public List<ListViewColumn> getColumns() {
        ArrayList<ListViewColumn> rlist = new ArrayList<ListViewColumn>();
        UserPersonalViewProperty up = this.getUserProp();
        if (up == null) {
            rlist.add((ListViewColumn)new StatusColumn());
            rlist.add((ListViewColumn)new WeatherColumn());
            rlist.add((ListViewColumn)new JobColumn());
            rlist.add((ListViewColumn)new LastSuccessColumn());
            rlist.add((ListViewColumn)new LastFailureColumn());
            rlist.add((ListViewColumn)new LastStableColumn());
            rlist.add((ListViewColumn)new LastDurationColumn());
            rlist.add(new ConsoleViewColumn());
            rlist.add((ListViewColumn)new BuildButtonColumn());
        } else {
            if (up.isPcStatus()) {
                rlist.add((ListViewColumn)new StatusColumn());
            }
            if (up.isPcWeather()) {
                rlist.add((ListViewColumn)new WeatherColumn());
            }
            if (up.isPcJob()) {
                rlist.add((ListViewColumn)new JobColumn());
            }
            if (up.isPcLastSuccess()) {
                rlist.add((ListViewColumn)new LastSuccessColumn());
            }
            if (up.isPcLastFailure()) {
                rlist.add((ListViewColumn)new LastFailureColumn());
            }
            if (up.isPcLastStable()) {
                rlist.add((ListViewColumn)new LastStableColumn());
            }
            if (up.isPcLastDuration()) {
                rlist.add((ListViewColumn)new LastDurationColumn());
            }
            if (up.isPcConsoleView()) {
                rlist.add(new ConsoleViewColumn());
            }
            if (up.isPcBuildButton()) {
                rlist.add((ListViewColumn)new BuildButtonColumn());
            }
        }
        return rlist;
    }

    public final PViewLinkAction getSiView(String rootProject) throws CloneNotSupportedException {
        StaplerRequest req = Stapler.getCurrentRequest();
        req.setAttribute("rootProject", (Object)rootProject);
        return this;
    }

    public final PViewLinkAction getRootSiView() throws CloneNotSupportedException {
        StaplerRequest req = Stapler.getCurrentRequest();
        req.removeAttribute("rootProject");
        return this;
    }
}

