/*
 * Decompiled with CFR 0.152.
 */
package de.fspengler.hudson.plugin;

import de.fspengler.hudson.plugin.LogActionProperty;
import hudson.Util;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogItemListener
extends RunListener<Run> {
    public void onCompleted(Run r, TaskListener listener) {
        LogActionProperty.LogActionDescriptor descriptor = LogActionProperty.DESCRIPTOR;
        if (!descriptor.isEnabled()) {
            return;
        }
        if (r.getResult() == Result.FAILURE && descriptor.isRestartEnabled() && descriptor.getRestartPattern() != null) {
            try {
                String log = Util.loadFile((File)r.getLogFile(), (Charset)r.getCharset());
                Matcher matcher = descriptor.getPatternForRestart().matcher(log);
                if (matcher.find()) {
                    if (descriptor.getRestartDescription().length() > 0) {
                        r.setDescription(descriptor.getRestartDescription());
                    }
                    Project project = (Project)Hudson.getInstance().getItemByFullName(r.getParent().getFullName(), Project.class);
                    project.scheduleBuild(descriptor.getRestartDelay().intValue());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected LogItemListener() {
        super(Run.class);
    }
}

