/*
 * Decompiled with CFR 0.152.
 */
package de.fspengler.hudson.plugin;

import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogActionProperty
extends JobProperty<Job<?, ?>> {
    public static final LogActionDescriptor DESCRIPTOR = new LogActionDescriptor();

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LogActionDescriptor
    extends JobPropertyDescriptor {
        private Boolean enabled;
        private Boolean restartEnabled;
        private String restartPattern;
        private String restartDescription;
        private Integer restartDelay;
        private transient Pattern pattern = null;

        public LogActionDescriptor() {
            super(LogActionProperty.class);
            this.load();
        }

        public String getDisplayName() {
            return "BuildLog Action";
        }

        public LogActionProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new LogActionProperty();
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            this.enabled = req.getParameter("logaction.enabled") != null;
            this.restartEnabled = req.getParameter("logaction.restartEnabled") != null;
            this.restartPattern = req.getParameter("logaction.restartPattern");
            this.restartDescription = req.getParameter("logaction.restartDescription");
            this.restartDelay = Integer.decode(req.getParameter("logaction.restartDelay"));
            this.pattern = null;
            this.save();
            return true;
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public boolean isEnabled() {
            return this.enabled != null ? this.enabled : false;
        }

        public void setEnabled(Boolean enable) {
            this.enabled = enable;
        }

        public String getRestartPattern() {
            return this.restartPattern;
        }

        public void setRestartPattern(String restartPattern) {
            this.restartPattern = restartPattern;
            this.pattern = null;
        }

        public boolean isRestartEnabled() {
            return this.restartEnabled != null ? this.restartEnabled : false;
        }

        public void setRestartEnabled(Boolean restartEnabled) {
            this.restartEnabled = restartEnabled;
        }

        public Pattern getPatternForRestart() {
            if (this.pattern == null && this.restartPattern != null) {
                this.pattern = Pattern.compile(this.restartPattern);
            }
            return this.pattern;
        }

        public String getRestartDescription() {
            if (this.restartDescription == null) {
                this.restartDescription = "restart on Pattern";
            }
            return this.restartDescription;
        }

        public void setRestartDescription(String restartDescription) {
            this.restartDescription = restartDescription;
        }

        public Integer getRestartDelay() {
            if (this.restartDelay == null) {
                this.restartDelay = 10;
            }
            return this.restartDelay;
        }

        public void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }
    }
}

