/*
 * Decompiled with CFR 0.152.
 */
package de.fruiture.cor.jenkins;

import de.fruiture.cor.jenkins.Version;
import java.io.Serializable;

public abstract class VersioningStrategy
implements Serializable {
    protected Change change = Change.PATCH;

    abstract Version getNextVersion(Version var1, Version var2);

    void patchChange() {
        if (this.change.ordinal() < Change.PATCH.ordinal()) {
            this.change = Change.PATCH;
        }
    }

    void minorChange() {
        if (this.change.ordinal() < Change.MINOR.ordinal()) {
            this.change = Change.MINOR;
        }
    }

    void majorChange() {
        this.change = Change.MAJOR;
    }

    static class Snapshot
    extends VersioningStrategy {
        private static final String SNAPSHOT_START = "SNAPSHOT.0";

        Snapshot() {
        }

        @Override
        Version getNextVersion(Version lastRelease, Version lastSnapshot) {
            Version snapshotMin;
            switch (this.change) {
                case MAJOR: {
                    snapshotMin = lastRelease.incrementMajorVersion(SNAPSHOT_START);
                    break;
                }
                case MINOR: {
                    snapshotMin = lastRelease.incrementMinorVersion(SNAPSHOT_START);
                    break;
                }
                default: {
                    snapshotMin = lastRelease.incrementPatchVersion(SNAPSHOT_START);
                }
            }
            if (lastSnapshot != null) {
                if (lastSnapshot.greaterThanOrEqualTo(snapshotMin)) {
                    return lastSnapshot.incrementPreReleaseVersion();
                }
                return snapshotMin;
            }
            return snapshotMin;
        }
    }

    static class Release
    extends VersioningStrategy {
        Release() {
        }

        @Override
        Version getNextVersion(Version lastRelease, Version lastSnapshot) {
            Version relMin;
            switch (this.change) {
                case MAJOR: {
                    relMin = lastRelease.incrementMajorVersion();
                    break;
                }
                case MINOR: {
                    relMin = lastRelease.incrementMinorVersion();
                    break;
                }
                default: {
                    relMin = lastRelease.incrementPatchVersion();
                }
            }
            if (lastSnapshot != null) {
                Version snapRelease = lastSnapshot.getNormalVersion();
                if (snapRelease.greaterThanOrEqualTo(relMin)) {
                    return snapRelease;
                }
                return relMin;
            }
            return relMin;
        }
    }

    static enum Change {
        PATCH,
        MINOR,
        MAJOR;

    }
}

