/*
 * Decompiled with CFR 0.152.
 */
package de.fruiture.cor.jenkins;

import de.fruiture.cor.jenkins.Version;
import de.fruiture.cor.jenkins.VersioningStrategy;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class VersionCalculator
implements Serializable {
    public static final Version START = new Version("0.0.0");
    private final VersioningStrategy strategy;
    private final String prefix;
    private final SortedSet<Version> versions = new TreeSet<Version>();
    private List<Pattern> triggerMinorChange = Collections.singletonList(Pattern.compile("CHANGE:MINOR"));
    private List<Pattern> triggerMajorChange = Collections.singletonList(Pattern.compile("CHANGE:MAJOR"));

    public static VersionCalculator snapshot(String prefix) {
        return new VersionCalculator(new VersioningStrategy.Snapshot(), prefix);
    }

    public static VersionCalculator snapshot() {
        return new VersionCalculator(new VersioningStrategy.Snapshot());
    }

    public static VersionCalculator release(String prefix) {
        return new VersionCalculator(new VersioningStrategy.Release(), prefix);
    }

    public static VersionCalculator release() {
        return new VersionCalculator(new VersioningStrategy.Release());
    }

    public VersionCalculator(VersioningStrategy strategy, String prefix) {
        this.prefix = prefix;
        this.strategy = strategy;
        assert (prefix == null || prefix.matches("^[\\w_\\-.]+$"));
    }

    public VersionCalculator(VersioningStrategy strategy) {
        this(strategy, null);
    }

    void tags(String foundGitTags) {
        Pattern p = this.prefix != null ? Pattern.compile(Pattern.quote(this.prefix) + "(\\d+.\\d+\\.\\d+\\S*)") : Pattern.compile("(\\d+.\\d+\\.\\d+\\S*)");
        Matcher matcher = p.matcher(foundGitTags);
        while (matcher.find()) {
            String v = matcher.group(1);
            try {
                this.versions.add(new Version(v));
            }
            catch (Exception exception) {}
        }
    }

    private Optional<Version> lastRelease() {
        return this.versions.stream().filter(Version::isRelease).reduce(VersionCalculator::last);
    }

    private Version getBaseline() {
        return this.lastRelease().orElse(START);
    }

    private Optional<Version> lastSnapAfter(Version baseline) {
        return this.versions.stream().filter(Version::isSnapshot).filter(v -> v.greaterThan(baseline)).reduce(VersionCalculator::last);
    }

    public Optional<String> getReferenceTag() {
        Optional<Version> best = this.lastRelease().map(r -> this.lastSnapAfter((Version)r).orElse((Version)r));
        if (!best.isPresent()) {
            best = this.lastSnapAfter(START);
        }
        return best.map(Version::toString).map(this::prefixed);
    }

    public String getNextVersion() {
        Version baseline = this.getBaseline();
        return this.strategy.getNextVersion(baseline, this.lastSnapAfter(baseline).orElse(null)).toString();
    }

    public void messages(String messages) {
        if (!messages.trim().isEmpty()) {
            this.strategy.patchChange();
        }
        if (this.triggerMinorChange.stream().anyMatch(p -> p.matcher(messages).find())) {
            this.strategy.minorChange();
        }
        if (this.triggerMajorChange.stream().anyMatch(p -> p.matcher(messages).find())) {
            this.strategy.majorChange();
        }
    }

    private String prefixed(String v) {
        return this.prefix != null ? this.prefix + v : v;
    }

    public String getGitFindTagsCommand() {
        return this.prefix != null ? "tag -l --merged HEAD '" + this.prefixed("*") + "'" : "tag -l --merged HEAD";
    }

    public String getGitLogCommand() {
        return "log --pretty=oneline " + this.getGitLogVersionRange();
    }

    public String getGitLogVersionRange() {
        return this.getReferenceTag().map(from -> from + "..HEAD").orElse("HEAD");
    }

    public String getGitNextTagCommand() {
        return "tag -am 'Release " + this.getNextVersion() + "' " + this.getNextVersionTag();
    }

    public String getGitPushTagCommand() {
        return "push origin " + this.getNextVersionTag();
    }

    public String getNextVersionTag() {
        return this.prefixed(this.getNextVersion());
    }

    public List<Pattern> getTriggerMinorChange() {
        return this.triggerMinorChange;
    }

    public void setTriggerMinorChange(List<?> triggerMinorChange) {
        this.triggerMinorChange = VersionCalculator.patterns(triggerMinorChange);
    }

    private static List<Pattern> patterns(List<?> rawList) {
        return rawList.stream().map(o -> {
            if (o instanceof Pattern) {
                return (Pattern)o;
            }
            return Pattern.compile(o.toString());
        }).collect(Collectors.toList());
    }

    public List<Pattern> getTriggerMajorChange() {
        return this.triggerMajorChange;
    }

    public void setTriggerMajorChange(List<?> triggerMajorChange) {
        this.triggerMajorChange = VersionCalculator.patterns(triggerMajorChange);
    }

    private static <T> T last(T a, T b) {
        return b;
    }
}

