/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.structure;

import de.frontsy.picciotto.structure.Sheet;
import java.util.Set;
import lombok.NonNull;

public class Workbook {
    public static final String DEFAULT_SHEET_NAME = "Workbook";
    private final String name;
    private final Set<Sheet> sheets;

    public Workbook(@NonNull String name, @NonNull Set<Sheet> sheets) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (sheets == null) {
            throw new NullPointerException("sheets is marked non-null but is null");
        }
        this.name = name;
        this.sheets = sheets;
    }

    public static WorkbookBuilder builder() {
        return new WorkbookBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Set<Sheet> getSheets() {
        return this.sheets;
    }

    public String toString() {
        return "Workbook(name=" + this.getName() + ", sheets=" + this.getSheets() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Workbook)) {
            return false;
        }
        Workbook other = (Workbook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Set<Sheet> this$sheets = this.getSheets();
        Set<Sheet> other$sheets = other.getSheets();
        return !(this$sheets == null ? other$sheets != null : !((Object)this$sheets).equals(other$sheets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Workbook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Set<Sheet> $sheets = this.getSheets();
        result = result * 59 + ($sheets == null ? 43 : ((Object)$sheets).hashCode());
        return result;
    }

    public static class WorkbookBuilder {
        private String name;
        private Set<Sheet> sheets;

        WorkbookBuilder() {
        }

        public WorkbookBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WorkbookBuilder sheets(Set<Sheet> sheets) {
            this.sheets = sheets;
            return this;
        }

        public Workbook build() {
            return new Workbook(this.name, this.sheets);
        }

        public String toString() {
            return "Workbook.WorkbookBuilder(name=" + this.name + ", sheets=" + this.sheets + ")";
        }
    }
}

