/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.structure;

import de.frontsy.picciotto.structure.Row;
import java.util.List;
import lombok.NonNull;

public class Sheet {
    private final String name;
    private final List<Row> rows;

    public Sheet(@NonNull String name, @NonNull List<Row> rows) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        this.name = name;
        this.rows = rows;
    }

    public static SheetBuilder builder() {
        return new SheetBuilder();
    }

    public String getName() {
        return this.name;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sheet)) {
            return false;
        }
        Sheet other = (Sheet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Row> this$rows = this.getRows();
        List<Row> other$rows = other.getRows();
        return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sheet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Row> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        return result;
    }

    public String toString() {
        return "Sheet(name=" + this.getName() + ", rows=" + this.getRows() + ")";
    }

    public static class SheetBuilder {
        private String name;
        private List<Row> rows;

        SheetBuilder() {
        }

        public SheetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SheetBuilder rows(List<Row> rows) {
            this.rows = rows;
            return this;
        }

        public Sheet build() {
            return new Sheet(this.name, this.rows);
        }

        public String toString() {
            return "Sheet.SheetBuilder(name=" + this.name + ", rows=" + this.rows + ")";
        }
    }
}

