/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.structure;

import de.frontsy.picciotto.convert.Visitor;
import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import de.frontsy.picciotto.structure.SpreadSheetElement;
import java.util.HashMap;
import java.util.Map;

public class Cell
implements SpreadSheetElement {
    private final int rowspan;
    private final int colspan;
    private int index;
    private final Map<String, PoiStyle> styles;
    private final String value;

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    private static Map<String, PoiStyle> $default$styles() {
        return new HashMap<String, PoiStyle>();
    }

    Cell(int rowspan, int colspan, int index, Map<String, PoiStyle> styles, String value) {
        this.rowspan = rowspan;
        this.colspan = colspan;
        this.index = index;
        this.styles = styles;
        this.value = value;
    }

    public static CellBuilder builder() {
        return new CellBuilder();
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public int getColspan() {
        return this.colspan;
    }

    public int getIndex() {
        return this.index;
    }

    public Map<String, PoiStyle> getStyles() {
        return this.styles;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cell)) {
            return false;
        }
        Cell other = (Cell)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRowspan() != other.getRowspan()) {
            return false;
        }
        if (this.getColspan() != other.getColspan()) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        Map<String, PoiStyle> this$styles = this.getStyles();
        Map<String, PoiStyle> other$styles = other.getStyles();
        if (this$styles == null ? other$styles != null : !((Object)this$styles).equals(other$styles)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cell;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRowspan();
        result = result * 59 + this.getColspan();
        result = result * 59 + this.getIndex();
        Map<String, PoiStyle> $styles = this.getStyles();
        result = result * 59 + ($styles == null ? 43 : ((Object)$styles).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "Cell(rowspan=" + this.getRowspan() + ", colspan=" + this.getColspan() + ", index=" + this.getIndex() + ", styles=" + this.getStyles() + ", value=" + this.getValue() + ")";
    }

    public static class CellBuilder {
        private int rowspan;
        private int colspan;
        private int index;
        private boolean styles$set;
        private Map<String, PoiStyle> styles$value;
        private String value;

        CellBuilder() {
        }

        public CellBuilder rowspan(int rowspan) {
            this.rowspan = rowspan;
            return this;
        }

        public CellBuilder colspan(int colspan) {
            this.colspan = colspan;
            return this;
        }

        public CellBuilder index(int index) {
            this.index = index;
            return this;
        }

        public CellBuilder styles(Map<String, PoiStyle> styles) {
            this.styles$value = styles;
            this.styles$set = true;
            return this;
        }

        public CellBuilder value(String value) {
            this.value = value;
            return this;
        }

        public Cell build() {
            Map<String, PoiStyle> styles$value = this.styles$value;
            if (!this.styles$set) {
                styles$value = Cell.$default$styles();
            }
            return new Cell(this.rowspan, this.colspan, this.index, styles$value, this.value);
        }

        public String toString() {
            return "Cell.CellBuilder(rowspan=" + this.rowspan + ", colspan=" + this.colspan + ", index=" + this.index + ", styles$value=" + this.styles$value + ", value=" + this.value + ")";
        }
    }
}

