/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.parse.xml;

import de.frontsy.picciotto.parse.Parser;
import de.frontsy.picciotto.parse.xml.QNames;
import de.frontsy.picciotto.parse.xml.RowParser;
import de.frontsy.picciotto.structure.Cell;
import de.frontsy.picciotto.structure.Row;
import de.frontsy.picciotto.structure.Sheet;
import de.frontsy.picciotto.structure.Workbook;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlParser
implements Parser {
    final Logger logger = LoggerFactory.getLogger(XmlParser.class);
    private RowParser rowParser;

    private List<Row> findRows(XmlCursor cursor) {
        ArrayList<Row> rows = new ArrayList<Row>();
        XmlCursor tempCursor = cursor.newCursor();
        tempCursor.selectPath("./row");
        while (tempCursor.toNextSelection()) {
            Optional<Row> row = this.rowParser.parse(tempCursor.xmlText());
            if (!row.isPresent()) continue;
            rows.add(row.orElseThrow());
        }
        tempCursor.dispose();
        return rows;
    }

    private Workbook createErrorWorkbook(Exception e) {
        List<Cell> cells = List.of(Cell.builder().value(e.getMessage()).build());
        List<Row> rows = List.of(Row.builder().cells(cells).build());
        Set<Sheet> sheet = Set.of(Sheet.builder().name("Error!!").rows(rows).build());
        Workbook workbook = Workbook.builder().name("Uh, oh..").sheets(sheet).build();
        return workbook;
    }

    private Optional<Workbook> doParse(String xml) {
        XmlCursor cursor = null;
        Workbook workbook = null;
        try {
            cursor = XmlObject.Factory.parse((String)xml).newCursor();
        }
        catch (XmlException e) {
            this.logger.error(e.getMessage());
            return Optional.of(this.createErrorWorkbook((Exception)((Object)e)));
        }
        if (cursor != null) {
            cursor.selectPath("/workbook");
            if (cursor.hasNextSelection()) {
                HashSet<Sheet> sheets = new HashSet<Sheet>();
                cursor.toNextSelection();
                cursor.push();
                String name = cursor.getAttributeText(QNames.NAME);
                if (name == null) {
                    name = cursor.toChild(QNames.NAME) ? cursor.getTextValue() : "Workbook";
                }
                cursor.pop();
                cursor.selectPath("sheet");
                if (cursor.hasNextSelection()) {
                    while (cursor.toNextSelection()) {
                        name = cursor.getAttributeText(QNames.NAME);
                        if (name == null) {
                            name = cursor.toChild(QNames.NAME) ? cursor.getTextValue() : "Workbook";
                        }
                        List<Row> rows = this.findRows(cursor);
                        Sheet sheet = Sheet.builder().name(name).rows(rows).build();
                        sheets.add(sheet);
                    }
                }
                workbook = Workbook.builder().name(name).sheets(sheets).build();
            }
        }
        if (workbook != null) {
            return Optional.of(workbook);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Workbook> parse(String content) {
        return this.doParse(content);
    }

    XmlParser(RowParser rowParser) {
        this.rowParser = rowParser;
    }

    public static XmlParserBuilder builder() {
        return new XmlParserBuilder();
    }

    public static class XmlParserBuilder {
        private RowParser rowParser;

        XmlParserBuilder() {
        }

        public XmlParserBuilder rowParser(RowParser rowParser) {
            this.rowParser = rowParser;
            return this;
        }

        public XmlParser build() {
            return new XmlParser(this.rowParser);
        }

        public String toString() {
            return "XmlParser.XmlParserBuilder(rowParser=" + this.rowParser + ")";
        }
    }
}

