/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.parse.xml;

import de.frontsy.picciotto.parse.xml.CellParser;
import de.frontsy.picciotto.parse.xml.QNames;
import de.frontsy.picciotto.structure.Cell;
import de.frontsy.picciotto.structure.Row;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowParser {
    private static final Logger log = LoggerFactory.getLogger(RowParser.class);
    private CellParser cellParser;

    public Optional<Row> parse(String text) {
        Row row = null;
        XmlCursor cursor = null;
        try {
            cursor = XmlObject.Factory.parse((String)text).newCursor();
        }
        catch (XmlException e) {
            log.error(e.getMessage());
        }
        cursor.selectPath("//row");
        boolean rowIndex = false;
        while (cursor.toNextSelection()) {
            ArrayList<Cell> cells = new ArrayList<Cell>();
            if (cursor.toChild(QNames.CELL)) {
                do {
                    Optional<Cell> cell;
                    if (!(cell = this.cellParser.parse(cursor.xmlText())).isPresent()) continue;
                    cells.add(cell.orElseThrow());
                } while (cursor.toNextSibling(QNames.CELL));
            }
            row = Row.builder().cells(cells).build();
        }
        if (row != null) {
            return Optional.of(row);
        }
        return Optional.empty();
    }

    RowParser(CellParser cellParser) {
        this.cellParser = cellParser;
    }

    public static RowParserBuilder builder() {
        return new RowParserBuilder();
    }

    public static class RowParserBuilder {
        private CellParser cellParser;

        RowParserBuilder() {
        }

        public RowParserBuilder cellParser(CellParser cellParser) {
            this.cellParser = cellParser;
            return this;
        }

        public RowParser build() {
            return new RowParser(this.cellParser);
        }

        public String toString() {
            return "RowParser.RowParserBuilder(cellParser=" + this.cellParser + ")";
        }
    }
}

