/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.parse.xml;

import de.frontsy.picciotto.convert.poi.cell.style.AbstractStyleFactory;
import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import de.frontsy.picciotto.parse.css.CSSParser;
import de.frontsy.picciotto.parse.css.Rule;
import de.frontsy.picciotto.parse.xml.QNames;
import de.frontsy.picciotto.structure.Cell;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellParser {
    private static final Logger log = LoggerFactory.getLogger(CellParser.class);
    public static final Cell ERROR_CELL = Cell.builder().value("ERROR").build();
    private CSSParser cssParser;

    private Optional<Integer> determineSpan(XmlCursor cursor, QName spanName) {
        Integer span = null;
        String spanAttribute = cursor.getAttributeText(spanName);
        if (spanAttribute != null && !spanAttribute.isBlank()) {
            try {
                span = Integer.parseInt(spanAttribute);
            }
            catch (NumberFormatException nfe) {
                log.warn(spanName + " attribute value: " + spanAttribute + " was not a number");
            }
        }
        if (span != null) {
            return Optional.of(span);
        }
        return Optional.empty();
    }

    private Map<String, PoiStyle> findStyles(String styleAttribute) {
        HashMap<String, PoiStyle> styles = new HashMap<String, PoiStyle>();
        HashSet<Rule> rules = new HashSet<Rule>();
        try {
            rules.addAll(this.cssParser.parseInline(styleAttribute));
        }
        catch (IllegalStateException illegalStateException) {
            log.error("Found invalid CSS: " + styleAttribute);
        }
        for (Rule rule : rules) {
            Optional<AbstractStyleFactory> styleFactory = AbstractStyleFactory.getStyleFactory(rule.getProperty());
            if (!styleFactory.isPresent()) continue;
            AbstractStyleFactory factory = styleFactory.get();
            PoiStyle style = factory.getStyle(rule);
            styles.put(rule.getProperty(), style);
        }
        return styles;
    }

    public Optional<Cell> parse(String xml) {
        XmlCursor cursor = null;
        try {
            cursor = XmlObject.Factory.parse((String)xml).newCursor();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        if (cursor != null) {
            cursor.toFirstChild();
            String styleAttribute = cursor.getAttributeText(QNames.STYLE);
            Map<String, PoiStyle> styles = styleAttribute != null ? this.findStyles(styleAttribute) : new HashMap<String, PoiStyle>();
            return Optional.of(Cell.builder().colspan(this.determineSpan(cursor, QNames.COLSPAN).orElse(0)).rowspan(this.determineSpan(cursor, QNames.ROWSPAN).orElse(0)).styles(styles).value(cursor.getTextValue()).build());
        }
        return Optional.empty();
    }

    CellParser(CSSParser cssParser) {
        this.cssParser = cssParser;
    }

    public static CellParserBuilder builder() {
        return new CellParserBuilder();
    }

    public static class CellParserBuilder {
        private CSSParser cssParser;

        CellParserBuilder() {
        }

        public CellParserBuilder cssParser(CSSParser cssParser) {
            this.cssParser = cssParser;
            return this;
        }

        public CellParser build() {
            return new CellParser(this.cssParser);
        }

        public String toString() {
            return "CellParser.CellParserBuilder(cssParser=" + this.cssParser + ")";
        }
    }
}

