/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.parse.css;

import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.decl.IHasCSSDeclarations;
import com.helger.css.decl.shorthand.CSSShortHandDescriptor;
import com.helger.css.decl.shorthand.CSSShortHandRegistry;
import com.helger.css.decl.visit.CSSVisitor;
import com.helger.css.decl.visit.DefaultCSSVisitor;
import com.helger.css.decl.visit.ICSSVisitor;
import com.helger.css.property.ECSSProperty;
import com.helger.css.reader.CSSReaderDeclarationList;
import de.frontsy.picciotto.parse.css.CSSParser;
import de.frontsy.picciotto.parse.css.Rule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PHCSSParser
implements CSSParser {
    private static final Logger log = LoggerFactory.getLogger(PHCSSParser.class);

    @Override
    public Set<Rule> parseSheet(String css) {
        return null;
    }

    @Override
    public Set<Rule> parseInline(String css) {
        final HashSet<Rule> rules = new HashSet<Rule>();
        CSSDeclarationList aDeclList = CSSReaderDeclarationList.readFromString((String)css, (ECSSVersion)ECSSVersion.CSS30);
        if (aDeclList == null) {
            throw new IllegalStateException("Failed to parse CSS: " + css);
        }
        DefaultCSSVisitor aVisitor = new DefaultCSSVisitor(){

            public void onDeclaration(@Nonnull CSSDeclaration declaration) {
                HashMap<String, String> properties = new HashMap<String, String>();
                if (declaration.getProperty().equals(ECSSProperty.BORDER.getName())) {
                    CSSShortHandDescriptor aSHD = CSSShortHandRegistry.getShortHandDescriptor((ECSSProperty)ECSSProperty.BORDER);
                    for (CSSDeclaration splitDeclaration : aSHD.getSplitIntoPieces(declaration)) {
                        properties.put(splitDeclaration.getProperty(), splitDeclaration.getExpressionAsCSSString());
                    }
                } else if (declaration.getProperty().equals(ECSSProperty.BORDER_TOP.getName())) {
                    CSSShortHandDescriptor aSHD = CSSShortHandRegistry.getShortHandDescriptor((ECSSProperty)ECSSProperty.BORDER_TOP);
                    for (CSSDeclaration splitDeclaration : aSHD.getSplitIntoPieces(declaration)) {
                        properties.put(splitDeclaration.getProperty(), splitDeclaration.getExpressionAsCSSString());
                    }
                } else if (declaration.getProperty().equals(ECSSProperty.BORDER_RIGHT.getName())) {
                    CSSShortHandDescriptor aSHD = CSSShortHandRegistry.getShortHandDescriptor((ECSSProperty)ECSSProperty.BORDER_RIGHT);
                    for (CSSDeclaration splitDeclaration : aSHD.getSplitIntoPieces(declaration)) {
                        properties.put(splitDeclaration.getProperty(), splitDeclaration.getExpressionAsCSSString());
                    }
                } else if (declaration.getProperty().equals(ECSSProperty.BORDER_BOTTOM.getName())) {
                    CSSShortHandDescriptor aSHD = CSSShortHandRegistry.getShortHandDescriptor((ECSSProperty)ECSSProperty.BORDER_BOTTOM);
                    for (CSSDeclaration splitDeclaration : aSHD.getSplitIntoPieces(declaration)) {
                        properties.put(splitDeclaration.getProperty(), splitDeclaration.getExpressionAsCSSString());
                    }
                } else if (declaration.getProperty().equals(ECSSProperty.BORDER_LEFT.getName())) {
                    CSSShortHandDescriptor aSHD = CSSShortHandRegistry.getShortHandDescriptor((ECSSProperty)ECSSProperty.BORDER_LEFT);
                    for (CSSDeclaration splitDeclaration : aSHD.getSplitIntoPieces(declaration)) {
                        properties.put(splitDeclaration.getProperty(), splitDeclaration.getExpressionAsCSSString());
                    }
                } else if (declaration.getProperty().equals(ECSSProperty.BACKGROUND.getName())) {
                    CSSShortHandDescriptor aSHD = CSSShortHandRegistry.getShortHandDescriptor((ECSSProperty)ECSSProperty.BACKGROUND);
                    for (CSSDeclaration splitDeclaration : aSHD.getSplitIntoPieces(declaration)) {
                        properties.put(splitDeclaration.getProperty(), splitDeclaration.getExpressionAsCSSString());
                    }
                } else {
                    properties.put(declaration.getProperty(), declaration.getExpressionAsCSSString());
                }
                rules.add(Rule.builder().property(declaration.getProperty()).values(properties).build());
            }
        };
        CSSVisitor.visitAllDeclarations((IHasCSSDeclarations)aDeclList, (ICSSVisitor)aVisitor);
        return rules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PHCSSParser)) {
            return false;
        }
        PHCSSParser other = (PHCSSParser)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof PHCSSParser;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "PHCSSParser()";
    }
}

