/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell.style;

import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TextAlign
implements PoiStyle {
    private final String value;

    @Override
    public void setStyle(XSSFCellStyle style, XSSFWorkbook workbook) {
        HorizontalAlignment alignment;
        switch (this.value) {
            case "end": 
            case "right": {
                alignment = HorizontalAlignment.RIGHT;
                break;
            }
            case "center": {
                alignment = HorizontalAlignment.CENTER;
                break;
            }
            case "justify": {
                alignment = HorizontalAlignment.JUSTIFY;
                break;
            }
            default: {
                alignment = HorizontalAlignment.LEFT;
            }
        }
        style.setAlignment(alignment);
    }

    TextAlign(String value) {
        this.value = value;
    }

    public static TextAlignBuilder builder() {
        return new TextAlignBuilder();
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextAlign)) {
            return false;
        }
        TextAlign other = (TextAlign)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextAlign;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "TextAlign(value=" + this.getValue() + ")";
    }

    public static class TextAlignBuilder {
        private String value;

        TextAlignBuilder() {
        }

        public TextAlignBuilder value(String value) {
            this.value = value;
            return this;
        }

        public TextAlign build() {
            return new TextAlign(this.value);
        }

        public String toString() {
            return "TextAlign.TextAlignBuilder(value=" + this.value + ")";
        }
    }
}

