/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell.style;

import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontWeight
implements PoiStyle {
    private static final Logger log = LoggerFactory.getLogger(FontWeight.class);
    public static final String DEFAULT_WEIGHT = "normal";
    private final String name;

    private boolean isFontWeightBold() {
        switch (this.name) {
            case "bold": 
            case "700": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setStyle(XSSFCellStyle style, XSSFWorkbook workbook) {
        XSSFFont font = style.getFont();
        font.setBold(this.isFontWeightBold());
    }

    FontWeight(String name) {
        this.name = name;
    }

    public static FontWeightBuilder builder() {
        return new FontWeightBuilder();
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FontWeight)) {
            return false;
        }
        FontWeight other = (FontWeight)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FontWeight;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "FontWeight(name=" + this.getName() + ")";
    }

    public static class FontWeightBuilder {
        private String name;

        FontWeightBuilder() {
        }

        public FontWeightBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FontWeight build() {
            return new FontWeight(this.name);
        }

        public String toString() {
            return "FontWeight.FontWeightBuilder(name=" + this.name + ")";
        }
    }
}

