/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell.style;

import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import java.util.Optional;
import org.apache.poi.ss.usermodel.FontFamily;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontStyle
implements PoiStyle {
    private static final Logger log = LoggerFactory.getLogger(FontStyle.class);
    public static final String DEFAULT_STYLE = "normal";
    private final String name;

    private Optional<FontFamily> determineFontFamily(String family) {
        switch (family) {
            case "normal": {
                return Optional.of(FontFamily.NOT_APPLICABLE);
            }
            case "cursive": {
                return Optional.of(FontFamily.DECORATIVE);
            }
        }
        return Optional.empty();
    }

    @Override
    public void setStyle(XSSFCellStyle style, XSSFWorkbook workbook) {
        XSSFFont font = style.getFont();
        Optional<FontFamily> attempt = this.determineFontFamily(this.name);
        if (attempt.isPresent()) {
            font.setFamily(attempt.get());
        }
    }

    FontStyle(String name) {
        this.name = name;
    }

    public static FontStyleBuilder builder() {
        return new FontStyleBuilder();
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FontStyle)) {
            return false;
        }
        FontStyle other = (FontStyle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FontStyle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "FontStyle(name=" + this.getName() + ")";
    }

    public static class FontStyleBuilder {
        private String name;

        FontStyleBuilder() {
        }

        public FontStyleBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FontStyle build() {
            return new FontStyle(this.name);
        }

        public String toString() {
            return "FontStyle.FontStyleBuilder(name=" + this.name + ")";
        }
    }
}

