/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell.style;

import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontFamily
implements PoiStyle {
    private static final Logger log = LoggerFactory.getLogger(FontFamily.class);
    public static final String DEFAULT_FAMILY = "normal";
    private final String name;

    @Override
    public void setStyle(XSSFCellStyle style, XSSFWorkbook workbook) {
        XSSFFont font = style.getFont();
        font.setFamily(org.apache.poi.ss.usermodel.FontFamily.SCRIPT);
    }

    FontFamily(String name) {
        this.name = name;
    }

    public static FontFamilyBuilder builder() {
        return new FontFamilyBuilder();
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FontFamily)) {
            return false;
        }
        FontFamily other = (FontFamily)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FontFamily;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "FontFamily(name=" + this.getName() + ")";
    }

    public static class FontFamilyBuilder {
        private String name;

        FontFamilyBuilder() {
        }

        public FontFamilyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FontFamily build() {
            return new FontFamily(this.name);
        }

        public String toString() {
            return "FontFamily.FontFamilyBuilder(name=" + this.name + ")";
        }
    }
}

