/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell.style;

import de.frontsy.picciotto.convert.poi.ColorConverter;
import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Color
implements PoiStyle {
    private static final Logger log = LoggerFactory.getLogger(Color.class);
    public static final String DEFAULT_VALUE = "#000000";
    String value;

    @Override
    public void setStyle(XSSFCellStyle style, XSSFWorkbook workbook) {
        String color;
        XSSFFont font = workbook.createFont();
        Optional<String> colorAttempt = ColorConverter.toHex(this.value);
        if (colorAttempt.isPresent()) {
            color = colorAttempt.get();
        } else {
            color = DEFAULT_VALUE;
            log.warn("Couldn't find hex value for: " + this.value);
        }
        font.setColor(ColorConverter.hexToXSSFColor(color));
        style.setFont((Font)font);
    }

    Color(String value) {
        this.value = value;
    }

    public static ColorBuilder builder() {
        return new ColorBuilder();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Color)) {
            return false;
        }
        Color other = (Color)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Color;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "Color(value=" + this.getValue() + ")";
    }

    public static class ColorBuilder {
        private String value;

        ColorBuilder() {
        }

        public ColorBuilder value(String value) {
            this.value = value;
            return this;
        }

        public Color build() {
            return new Color(this.value);
        }

        public String toString() {
            return "Color.ColorBuilder(value=" + this.value + ")";
        }
    }
}

