/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell.style;

import de.frontsy.picciotto.convert.poi.ColorConverter;
import de.frontsy.picciotto.convert.poi.cell.style.AbstractStyleFactory;
import de.frontsy.picciotto.convert.poi.cell.style.BorderTop;
import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import de.frontsy.picciotto.parse.css.Rule;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BorderTopStyleFactory
extends AbstractStyleFactory {
    private static final Logger log = LoggerFactory.getLogger(BorderTopStyleFactory.class);

    @Override
    public PoiStyle getStyle(Rule rule) {
        String color;
        Map<String, String> properties = rule.getValues();
        if (properties.containsKey("border-top-color")) {
            String colorProperty = properties.get("border-top-color");
            try {
                color = ColorConverter.toHex(colorProperty).orElse("#000000");
            }
            catch (IllegalArgumentException iae) {
                log.warn("Was unable to decode: " + colorProperty);
                color = "#000000";
            }
        } else {
            color = "#000000";
        }
        String width = properties.getOrDefault("border-top-width", "normal");
        String style = properties.getOrDefault("border-top-style", "normal");
        return BorderTop.builder().color(color).width(width).style(style).build();
    }
}

