/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell.style;

import de.frontsy.picciotto.convert.poi.ColorConverter;
import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BorderTop
implements PoiStyle {
    private static final Logger log = LoggerFactory.getLogger(BorderTop.class);
    String color;
    String width;
    String style;

    protected BorderStyle determineBorderStyle() {
        switch (this.style) {
            case "thin": {
                return BorderStyle.HAIR;
            }
            case "dotted": {
                return BorderStyle.DOTTED;
            }
            case "dashed": {
                return BorderStyle.DASHED;
            }
        }
        return BorderStyle.MEDIUM;
    }

    @Override
    public void setStyle(XSSFCellStyle style, XSSFWorkbook workbook) {
        style.setBorderColor(XSSFCellBorder.BorderSide.TOP, ColorConverter.hexToXSSFColor(this.color));
        style.setBorderTop(this.determineBorderStyle());
    }

    BorderTop(String color, String width, String style) {
        this.color = color;
        this.width = width;
        this.style = style;
    }

    public static BorderTopBuilder builder() {
        return new BorderTopBuilder();
    }

    public String getColor() {
        return this.color;
    }

    public String getWidth() {
        return this.width;
    }

    public String getStyle() {
        return this.style;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BorderTop)) {
            return false;
        }
        BorderTop other = (BorderTop)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$width = this.getWidth();
        String other$width = other.getWidth();
        if (this$width == null ? other$width != null : !this$width.equals(other$width)) {
            return false;
        }
        String this$style = this.getStyle();
        String other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !this$style.equals(other$style));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BorderTop;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : $width.hashCode());
        String $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        return result;
    }

    public String toString() {
        return "BorderTop(color=" + this.getColor() + ", width=" + this.getWidth() + ", style=" + this.getStyle() + ")";
    }

    public static class BorderTopBuilder {
        private String color;
        private String width;
        private String style;

        BorderTopBuilder() {
        }

        public BorderTopBuilder color(String color) {
            this.color = color;
            return this;
        }

        public BorderTopBuilder width(String width) {
            this.width = width;
            return this;
        }

        public BorderTopBuilder style(String style) {
            this.style = style;
            return this;
        }

        public BorderTop build() {
            return new BorderTop(this.color, this.width, this.style);
        }

        public String toString() {
            return "BorderTop.BorderTopBuilder(color=" + this.color + ", width=" + this.width + ", style=" + this.style + ")";
        }
    }
}

