/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell.style;

import de.frontsy.picciotto.convert.poi.ColorConverter;
import de.frontsy.picciotto.convert.poi.cell.style.AbstractStyleFactory;
import de.frontsy.picciotto.convert.poi.cell.style.BorderRight;
import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import de.frontsy.picciotto.parse.css.Rule;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BorderRightStyleFactory
extends AbstractStyleFactory {
    private static final Logger log = LoggerFactory.getLogger(BorderRightStyleFactory.class);

    @Override
    public PoiStyle getStyle(Rule rule) {
        String color;
        Map<String, String> properties = rule.getValues();
        if (properties.containsKey("border-right-color")) {
            String colorProperty = properties.get("border-right-color");
            try {
                color = ColorConverter.toHex(colorProperty).orElse("#000000");
            }
            catch (IllegalArgumentException iae) {
                log.warn("Was unable to decode: " + colorProperty);
                color = "#000000";
            }
        } else {
            color = "#000000";
        }
        String width = properties.getOrDefault("border-right-width", "normal");
        String style = properties.getOrDefault("border-right-style", "normal");
        return BorderRight.builder().color(color).width(width).style(style).build();
    }
}

