/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell.style;

import de.frontsy.picciotto.convert.poi.ColorConverter;
import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BorderRight
implements PoiStyle {
    private static final Logger log = LoggerFactory.getLogger(BorderRight.class);
    String color;
    String width;
    String style;

    protected BorderStyle determineBorderStyle() {
        switch (this.style) {
            case "thin": {
                return BorderStyle.HAIR;
            }
            case "dotted": {
                return BorderStyle.DOTTED;
            }
            case "dashed": {
                return BorderStyle.DASHED;
            }
        }
        return BorderStyle.MEDIUM;
    }

    @Override
    public void setStyle(XSSFCellStyle style, XSSFWorkbook workbook) {
        style.setBorderColor(XSSFCellBorder.BorderSide.RIGHT, ColorConverter.hexToXSSFColor(this.color));
        style.setBorderRight(this.determineBorderStyle());
    }

    BorderRight(String color, String width, String style) {
        this.color = color;
        this.width = width;
        this.style = style;
    }

    public static BorderRightBuilder builder() {
        return new BorderRightBuilder();
    }

    public String getColor() {
        return this.color;
    }

    public String getWidth() {
        return this.width;
    }

    public String getStyle() {
        return this.style;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BorderRight)) {
            return false;
        }
        BorderRight other = (BorderRight)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$width = this.getWidth();
        String other$width = other.getWidth();
        if (this$width == null ? other$width != null : !this$width.equals(other$width)) {
            return false;
        }
        String this$style = this.getStyle();
        String other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !this$style.equals(other$style));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BorderRight;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : $width.hashCode());
        String $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        return result;
    }

    public String toString() {
        return "BorderRight(color=" + this.getColor() + ", width=" + this.getWidth() + ", style=" + this.getStyle() + ")";
    }

    public static class BorderRightBuilder {
        private String color;
        private String width;
        private String style;

        BorderRightBuilder() {
        }

        public BorderRightBuilder color(String color) {
            this.color = color;
            return this;
        }

        public BorderRightBuilder width(String width) {
            this.width = width;
            return this;
        }

        public BorderRightBuilder style(String style) {
            this.style = style;
            return this;
        }

        public BorderRight build() {
            return new BorderRight(this.color, this.width, this.style);
        }

        public String toString() {
            return "BorderRight.BorderRightBuilder(color=" + this.color + ", width=" + this.width + ", style=" + this.style + ")";
        }
    }
}

