/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell.style;

import de.frontsy.picciotto.convert.poi.ColorConverter;
import de.frontsy.picciotto.convert.poi.cell.PoiBorderStyleFactory;
import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import de.frontsy.picciotto.parse.css.Rule;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Border
implements PoiStyle {
    private static final Logger log = LoggerFactory.getLogger(Border.class);
    public static final String DEFAULT_COLOR = "#000000";
    public static final String DEFAULT_STYLE = "normal";
    private String top;
    private String right;
    private String bottom;
    private String left;
    private String width;
    private String color;
    private String style;

    @Override
    public void setStyle(XSSFCellStyle style, XSSFWorkbook workbook) {
        BorderStyle borderStyle = PoiBorderStyleFactory.getBorder(Rule.builder().values(Map.of("border-style", this.style, "border-width", this.width)).build()).orElseThrow();
        style.setBorderTop(borderStyle);
        style.setBorderRight(borderStyle);
        style.setBorderBottom(borderStyle);
        style.setBorderLeft(borderStyle);
        XSSFColor borderColor = ColorConverter.hexToXSSFColor(this.color);
        style.setBorderColor(XSSFCellBorder.BorderSide.TOP, borderColor);
        style.setBorderColor(XSSFCellBorder.BorderSide.RIGHT, borderColor);
        style.setBorderColor(XSSFCellBorder.BorderSide.BOTTOM, borderColor);
        style.setBorderColor(XSSFCellBorder.BorderSide.LEFT, borderColor);
    }

    private static String $default$color() {
        return DEFAULT_COLOR;
    }

    private static String $default$style() {
        return DEFAULT_STYLE;
    }

    Border(String top, String right, String bottom, String left, String width, String color, String style) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
        this.width = width;
        this.color = color;
        this.style = style;
    }

    public static BorderBuilder builder() {
        return new BorderBuilder();
    }

    public String getTop() {
        return this.top;
    }

    public String getRight() {
        return this.right;
    }

    public String getBottom() {
        return this.bottom;
    }

    public String getLeft() {
        return this.left;
    }

    public String getWidth() {
        return this.width;
    }

    public String getColor() {
        return this.color;
    }

    public String getStyle() {
        return this.style;
    }

    public void setTop(String top) {
        this.top = top;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public void setBottom(String bottom) {
        this.bottom = bottom;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Border)) {
            return false;
        }
        Border other = (Border)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$top = this.getTop();
        String other$top = other.getTop();
        if (this$top == null ? other$top != null : !this$top.equals(other$top)) {
            return false;
        }
        String this$right = this.getRight();
        String other$right = other.getRight();
        if (this$right == null ? other$right != null : !this$right.equals(other$right)) {
            return false;
        }
        String this$bottom = this.getBottom();
        String other$bottom = other.getBottom();
        if (this$bottom == null ? other$bottom != null : !this$bottom.equals(other$bottom)) {
            return false;
        }
        String this$left = this.getLeft();
        String other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        String this$width = this.getWidth();
        String other$width = other.getWidth();
        if (this$width == null ? other$width != null : !this$width.equals(other$width)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$style = this.getStyle();
        String other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !this$style.equals(other$style));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Border;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $top = this.getTop();
        result = result * 59 + ($top == null ? 43 : $top.hashCode());
        String $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        String $bottom = this.getBottom();
        result = result * 59 + ($bottom == null ? 43 : $bottom.hashCode());
        String $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        String $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : $width.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        return result;
    }

    public String toString() {
        return "Border(top=" + this.getTop() + ", right=" + this.getRight() + ", bottom=" + this.getBottom() + ", left=" + this.getLeft() + ", width=" + this.getWidth() + ", color=" + this.getColor() + ", style=" + this.getStyle() + ")";
    }

    public static class BorderBuilder {
        private String top;
        private String right;
        private String bottom;
        private String left;
        private String width;
        private boolean color$set;
        private String color$value;
        private boolean style$set;
        private String style$value;

        BorderBuilder() {
        }

        public BorderBuilder top(String top) {
            this.top = top;
            return this;
        }

        public BorderBuilder right(String right) {
            this.right = right;
            return this;
        }

        public BorderBuilder bottom(String bottom) {
            this.bottom = bottom;
            return this;
        }

        public BorderBuilder left(String left) {
            this.left = left;
            return this;
        }

        public BorderBuilder width(String width) {
            this.width = width;
            return this;
        }

        public BorderBuilder color(String color) {
            this.color$value = color;
            this.color$set = true;
            return this;
        }

        public BorderBuilder style(String style) {
            this.style$value = style;
            this.style$set = true;
            return this;
        }

        public Border build() {
            String color$value = this.color$value;
            if (!this.color$set) {
                color$value = Border.$default$color();
            }
            String style$value = this.style$value;
            if (!this.style$set) {
                style$value = Border.$default$style();
            }
            return new Border(this.top, this.right, this.bottom, this.left, this.width, color$value, style$value);
        }

        public String toString() {
            return "Border.BorderBuilder(top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ", left=" + this.left + ", width=" + this.width + ", color$value=" + this.color$value + ", style$value=" + this.style$value + ")";
        }
    }
}

