/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell.style;

import de.frontsy.picciotto.convert.poi.ColorConverter;
import de.frontsy.picciotto.convert.poi.cell.style.AbstractStyleFactory;
import de.frontsy.picciotto.convert.poi.cell.style.Background;
import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import de.frontsy.picciotto.parse.css.Rule;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundStyleFactory
extends AbstractStyleFactory {
    private static final Logger log = LoggerFactory.getLogger(BackgroundStyleFactory.class);
    public static final String DEFAULT_BACKGROUND_COLOR = "ffffff";
    public static final PoiStyle DEFAULT_BACKGROUND_STYLE = Background.builder().build();

    @Override
    public PoiStyle getStyle(Rule rule) {
        Map<String, String> properties = rule.getValues();
        if (properties != null) {
            String colorHex;
            if (properties.containsKey("background-color")) {
                Optional<String> colorAttempt = ColorConverter.toHex(properties.get("background-color"));
                colorHex = colorAttempt.orElse(DEFAULT_BACKGROUND_COLOR);
            } else {
                colorHex = DEFAULT_BACKGROUND_COLOR;
            }
            return Background.builder().color(colorHex).build();
        }
        return DEFAULT_BACKGROUND_STYLE;
    }
}

