/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell.style;

import de.frontsy.picciotto.convert.poi.ColorConverter;
import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Background
implements PoiStyle {
    private final String color;
    private final String backgroundImage;
    private final String backgroundPosition;
    private final String backgroundSize;
    private final String backgroundRepeat;
    private final String backgroundOrigin;
    private final String backgroundClip;
    private final String backgroundAttachment;

    @Override
    public void setStyle(XSSFCellStyle style, XSSFWorkbook workbook) {
        XSSFColor convertedColor = ColorConverter.hexToXSSFColor(this.color);
        style.setFillForegroundColor(convertedColor);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
    }

    Background(String color, String backgroundImage, String backgroundPosition, String backgroundSize, String backgroundRepeat, String backgroundOrigin, String backgroundClip, String backgroundAttachment) {
        this.color = color;
        this.backgroundImage = backgroundImage;
        this.backgroundPosition = backgroundPosition;
        this.backgroundSize = backgroundSize;
        this.backgroundRepeat = backgroundRepeat;
        this.backgroundOrigin = backgroundOrigin;
        this.backgroundClip = backgroundClip;
        this.backgroundAttachment = backgroundAttachment;
    }

    public static BackgroundBuilder builder() {
        return new BackgroundBuilder();
    }

    public String getColor() {
        return this.color;
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public String getBackgroundPosition() {
        return this.backgroundPosition;
    }

    public String getBackgroundSize() {
        return this.backgroundSize;
    }

    public String getBackgroundRepeat() {
        return this.backgroundRepeat;
    }

    public String getBackgroundOrigin() {
        return this.backgroundOrigin;
    }

    public String getBackgroundClip() {
        return this.backgroundClip;
    }

    public String getBackgroundAttachment() {
        return this.backgroundAttachment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Background)) {
            return false;
        }
        Background other = (Background)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$backgroundImage = this.getBackgroundImage();
        String other$backgroundImage = other.getBackgroundImage();
        if (this$backgroundImage == null ? other$backgroundImage != null : !this$backgroundImage.equals(other$backgroundImage)) {
            return false;
        }
        String this$backgroundPosition = this.getBackgroundPosition();
        String other$backgroundPosition = other.getBackgroundPosition();
        if (this$backgroundPosition == null ? other$backgroundPosition != null : !this$backgroundPosition.equals(other$backgroundPosition)) {
            return false;
        }
        String this$backgroundSize = this.getBackgroundSize();
        String other$backgroundSize = other.getBackgroundSize();
        if (this$backgroundSize == null ? other$backgroundSize != null : !this$backgroundSize.equals(other$backgroundSize)) {
            return false;
        }
        String this$backgroundRepeat = this.getBackgroundRepeat();
        String other$backgroundRepeat = other.getBackgroundRepeat();
        if (this$backgroundRepeat == null ? other$backgroundRepeat != null : !this$backgroundRepeat.equals(other$backgroundRepeat)) {
            return false;
        }
        String this$backgroundOrigin = this.getBackgroundOrigin();
        String other$backgroundOrigin = other.getBackgroundOrigin();
        if (this$backgroundOrigin == null ? other$backgroundOrigin != null : !this$backgroundOrigin.equals(other$backgroundOrigin)) {
            return false;
        }
        String this$backgroundClip = this.getBackgroundClip();
        String other$backgroundClip = other.getBackgroundClip();
        if (this$backgroundClip == null ? other$backgroundClip != null : !this$backgroundClip.equals(other$backgroundClip)) {
            return false;
        }
        String this$backgroundAttachment = this.getBackgroundAttachment();
        String other$backgroundAttachment = other.getBackgroundAttachment();
        return !(this$backgroundAttachment == null ? other$backgroundAttachment != null : !this$backgroundAttachment.equals(other$backgroundAttachment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Background;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $backgroundImage = this.getBackgroundImage();
        result = result * 59 + ($backgroundImage == null ? 43 : $backgroundImage.hashCode());
        String $backgroundPosition = this.getBackgroundPosition();
        result = result * 59 + ($backgroundPosition == null ? 43 : $backgroundPosition.hashCode());
        String $backgroundSize = this.getBackgroundSize();
        result = result * 59 + ($backgroundSize == null ? 43 : $backgroundSize.hashCode());
        String $backgroundRepeat = this.getBackgroundRepeat();
        result = result * 59 + ($backgroundRepeat == null ? 43 : $backgroundRepeat.hashCode());
        String $backgroundOrigin = this.getBackgroundOrigin();
        result = result * 59 + ($backgroundOrigin == null ? 43 : $backgroundOrigin.hashCode());
        String $backgroundClip = this.getBackgroundClip();
        result = result * 59 + ($backgroundClip == null ? 43 : $backgroundClip.hashCode());
        String $backgroundAttachment = this.getBackgroundAttachment();
        result = result * 59 + ($backgroundAttachment == null ? 43 : $backgroundAttachment.hashCode());
        return result;
    }

    public String toString() {
        return "Background(color=" + this.getColor() + ", backgroundImage=" + this.getBackgroundImage() + ", backgroundPosition=" + this.getBackgroundPosition() + ", backgroundSize=" + this.getBackgroundSize() + ", backgroundRepeat=" + this.getBackgroundRepeat() + ", backgroundOrigin=" + this.getBackgroundOrigin() + ", backgroundClip=" + this.getBackgroundClip() + ", backgroundAttachment=" + this.getBackgroundAttachment() + ")";
    }

    public static class BackgroundBuilder {
        private String color;
        private String backgroundImage;
        private String backgroundPosition;
        private String backgroundSize;
        private String backgroundRepeat;
        private String backgroundOrigin;
        private String backgroundClip;
        private String backgroundAttachment;

        BackgroundBuilder() {
        }

        public BackgroundBuilder color(String color) {
            this.color = color;
            return this;
        }

        public BackgroundBuilder backgroundImage(String backgroundImage) {
            this.backgroundImage = backgroundImage;
            return this;
        }

        public BackgroundBuilder backgroundPosition(String backgroundPosition) {
            this.backgroundPosition = backgroundPosition;
            return this;
        }

        public BackgroundBuilder backgroundSize(String backgroundSize) {
            this.backgroundSize = backgroundSize;
            return this;
        }

        public BackgroundBuilder backgroundRepeat(String backgroundRepeat) {
            this.backgroundRepeat = backgroundRepeat;
            return this;
        }

        public BackgroundBuilder backgroundOrigin(String backgroundOrigin) {
            this.backgroundOrigin = backgroundOrigin;
            return this;
        }

        public BackgroundBuilder backgroundClip(String backgroundClip) {
            this.backgroundClip = backgroundClip;
            return this;
        }

        public BackgroundBuilder backgroundAttachment(String backgroundAttachment) {
            this.backgroundAttachment = backgroundAttachment;
            return this;
        }

        public Background build() {
            return new Background(this.color, this.backgroundImage, this.backgroundPosition, this.backgroundSize, this.backgroundRepeat, this.backgroundOrigin, this.backgroundClip, this.backgroundAttachment);
        }

        public String toString() {
            return "Background.BackgroundBuilder(color=" + this.color + ", backgroundImage=" + this.backgroundImage + ", backgroundPosition=" + this.backgroundPosition + ", backgroundSize=" + this.backgroundSize + ", backgroundRepeat=" + this.backgroundRepeat + ", backgroundOrigin=" + this.backgroundOrigin + ", backgroundClip=" + this.backgroundClip + ", backgroundAttachment=" + this.backgroundAttachment + ")";
        }
    }
}

