/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Range {
    private static final Logger log = LoggerFactory.getLogger(Range.class);
    private int rowIndex;
    private int cellIndex;
    private int rowSpan;
    private int colSpan;

    public Integer getLastRow() {
        int lastRow = this.rowSpan > 1 ? this.rowIndex + (this.rowSpan - 1) : this.rowIndex;
        return lastRow;
    }

    public Integer getLastColumn() {
        int lastColumn = this.colSpan > 1 ? this.cellIndex + (this.colSpan - 1) : this.cellIndex;
        return lastColumn;
    }

    private static int $default$rowSpan() {
        return 1;
    }

    private static int $default$colSpan() {
        return 1;
    }

    Range(int rowIndex, int cellIndex, int rowSpan, int colSpan) {
        this.rowIndex = rowIndex;
        this.cellIndex = cellIndex;
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
    }

    public static RangeBuilder builder() {
        return new RangeBuilder();
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getCellIndex() {
        return this.cellIndex;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void setCellIndex(int cellIndex) {
        this.cellIndex = cellIndex;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRowIndex() != other.getRowIndex()) {
            return false;
        }
        if (this.getCellIndex() != other.getCellIndex()) {
            return false;
        }
        if (this.getRowSpan() != other.getRowSpan()) {
            return false;
        }
        return this.getColSpan() == other.getColSpan();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Range;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRowIndex();
        result = result * 59 + this.getCellIndex();
        result = result * 59 + this.getRowSpan();
        result = result * 59 + this.getColSpan();
        return result;
    }

    public String toString() {
        return "Range(rowIndex=" + this.getRowIndex() + ", cellIndex=" + this.getCellIndex() + ", rowSpan=" + this.getRowSpan() + ", colSpan=" + this.getColSpan() + ")";
    }

    public static class RangeBuilder {
        private int rowIndex;
        private int cellIndex;
        private boolean rowSpan$set;
        private int rowSpan$value;
        private boolean colSpan$set;
        private int colSpan$value;

        RangeBuilder() {
        }

        public RangeBuilder rowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
            return this;
        }

        public RangeBuilder cellIndex(int cellIndex) {
            this.cellIndex = cellIndex;
            return this;
        }

        public RangeBuilder rowSpan(int rowSpan) {
            this.rowSpan$value = rowSpan;
            this.rowSpan$set = true;
            return this;
        }

        public RangeBuilder colSpan(int colSpan) {
            this.colSpan$value = colSpan;
            this.colSpan$set = true;
            return this;
        }

        public Range build() {
            int rowSpan$value = this.rowSpan$value;
            if (!this.rowSpan$set) {
                rowSpan$value = Range.$default$rowSpan();
            }
            int colSpan$value = this.colSpan$value;
            if (!this.colSpan$set) {
                colSpan$value = Range.$default$colSpan();
            }
            return new Range(this.rowIndex, this.cellIndex, rowSpan$value, colSpan$value);
        }

        public String toString() {
            return "Range.RangeBuilder(rowIndex=" + this.rowIndex + ", cellIndex=" + this.cellIndex + ", rowSpan$value=" + this.rowSpan$value + ", colSpan$value=" + this.colSpan$value + ")";
        }
    }
}

