/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi.cell;

import de.frontsy.picciotto.parse.css.Rule;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.ss.usermodel.BorderStyle;

public class PoiBorderStyleFactory {
    public static Optional<BorderStyle> getBorder(Rule rule) {
        Map<String, String> values = rule.getValues();
        if (values.containsKey("border-width")) {
            String width = values.get("border-width");
            String style = values.get("border-style");
            if (style.isBlank() || style.equals("solid")) {
                if (width.indexOf("px") > 0) {
                    String pixelString = width.substring(0, width.indexOf("px"));
                    try {
                        Integer pixels = Integer.valueOf(pixelString);
                        if (pixels <= 2) {
                            return Optional.of(BorderStyle.THIN);
                        }
                        if (pixels <= 5) {
                            return Optional.of(BorderStyle.MEDIUM);
                        }
                        return Optional.of(BorderStyle.THICK);
                    }
                    catch (Exception e) {
                        return Optional.empty();
                    }
                }
                if (width.equals("thin")) {
                    return Optional.of(BorderStyle.THIN);
                }
                if (width.isBlank() || width.equals("medium")) {
                    return Optional.of(BorderStyle.MEDIUM);
                }
                if (width.equals("thick")) {
                    return Optional.of(BorderStyle.THICK);
                }
            } else {
                if (style.equals("dotted")) {
                    if (width.indexOf("px") > 0) {
                        String pixelString = width.substring(0, width.indexOf("px"));
                        try {
                            Integer pixels = Integer.valueOf(pixelString);
                            if (pixels <= 2) {
                                return Optional.of(BorderStyle.DOTTED);
                            }
                            return Optional.of(BorderStyle.MEDIUM_DASH_DOT);
                        }
                        catch (Exception e) {
                            return Optional.empty();
                        }
                    }
                    if (width.equals("thin")) {
                        return Optional.of(BorderStyle.DOTTED);
                    }
                    return Optional.of(BorderStyle.MEDIUM_DASH_DOT);
                }
                if (style.equals("dashed")) {
                    if (width.indexOf("px") > 0) {
                        String pixelString = width.substring(0, width.indexOf("px"));
                        try {
                            Integer pixels = Integer.valueOf(pixelString);
                            if (pixels <= 2) {
                                return Optional.of(BorderStyle.DASHED);
                            }
                            return Optional.of(BorderStyle.MEDIUM_DASHED);
                        }
                        catch (Exception e) {
                            return Optional.empty();
                        }
                    }
                    if (width.equals("thin")) {
                        return Optional.of(BorderStyle.DASHED);
                    }
                    return Optional.of(BorderStyle.MEDIUM_DASHED);
                }
            }
        }
        return Optional.empty();
    }
}

