/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert.poi;

import com.helger.css.utils.ECSSColor;
import java.awt.Color;
import java.util.Optional;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorConverter {
    private static final Logger log = LoggerFactory.getLogger(ColorConverter.class);

    public static Optional<String> toHex(String color) {
        String hex = null;
        if (color.startsWith("#")) {
            hex = color;
        } else {
            ECSSColor ecssColor = ECSSColor.getFromNameCaseInsensitiveOrNull((String)color);
            if (ecssColor != null) {
                hex = ecssColor.getAsHexColorValue();
            } else {
                log.error("Could not convert: " + color);
            }
        }
        if (hex != null) {
            return Optional.of(hex);
        }
        return Optional.empty();
    }

    public static XSSFColor hexToXSSFColor(String color) {
        Color decoded = Color.decode(color);
        try {
            int red = decoded.getRed();
            int green = decoded.getGreen();
            int blue = decoded.getBlue();
            XSSFColor result = new XSSFColor(new Color(red, green, blue), (IndexedColorMap)new DefaultIndexedColorMap());
            return result;
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            byte[] rgb = new byte[]{-1, -1, -1};
            return new XSSFColor(rgb, (IndexedColorMap)new DefaultIndexedColorMap());
        }
    }
}

