/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto.convert;

import de.frontsy.picciotto.convert.poi.BorderUtils;
import de.frontsy.picciotto.convert.poi.cell.Range;
import de.frontsy.picciotto.convert.poi.cell.style.PoiStyle;
import de.frontsy.picciotto.structure.Cell;
import de.frontsy.picciotto.structure.Row;
import de.frontsy.picciotto.structure.Sheet;
import de.frontsy.picciotto.structure.Workbook;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbookToPoi {
    private static final Logger log = LoggerFactory.getLogger(WorkbookToPoi.class);

    public static XSSFWorkbook workbookToXSSFWorkbook(Workbook workbook) {
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        for (Sheet sheet : workbook.getSheets()) {
            XSSFSheet xssfSheet = xssfWorkbook.createSheet(sheet.getName());
            int rowIndex = 0;
            for (Row row : sheet.getRows()) {
                XSSFRow xssfRow = xssfSheet.createRow(rowIndex);
                int cellIndex = 0;
                for (Cell cell : row.getCells()) {
                    XSSFCell xssfCell = xssfRow.createCell(cellIndex);
                    xssfCell.setCellValue(cell.getValue());
                    Map<String, PoiStyle> styles = cell.getStyles();
                    if (!styles.isEmpty()) {
                        XSSFCellStyle cellStyle = xssfWorkbook.createCellStyle();
                        for (PoiStyle style : styles.values()) {
                            try {
                                style.setStyle(cellStyle, xssfWorkbook);
                                xssfCell.setCellStyle((CellStyle)cellStyle);
                            }
                            catch (Exception e) {
                                log.error(e.getMessage());
                            }
                        }
                    }
                    WorkbookToPoi.doSpans(xssfSheet, rowIndex, cellIndex, cell, xssfCell);
                    ++cellIndex;
                }
                ++rowIndex;
            }
        }
        return xssfWorkbook;
    }

    private static void doSpans(XSSFSheet xssfSheet, int rowIndex, int cellIndex, Cell cell, XSSFCell xssfCell) {
        int rowSpan = cell.getRowspan();
        int colSpan = cell.getColspan();
        if (rowSpan > 0 || colSpan > 0) {
            Range range = Range.builder().cellIndex(cellIndex).rowIndex(rowIndex).colSpan(colSpan).rowSpan(rowSpan).build();
            try {
                if (xssfCell != null) {
                    CellRangeAddress mergedRegion = new CellRangeAddress(rowIndex, range.getLastRow().intValue(), cellIndex, range.getLastColumn().intValue());
                    xssfSheet.addMergedRegion(mergedRegion);
                    BorderUtils.setBorderTop(xssfSheet, xssfCell, mergedRegion);
                    BorderUtils.setBorderRight(xssfSheet, xssfCell, mergedRegion);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }
}

