/*
 * Decompiled with CFR 0.152.
 */
package de.frontsy.picciotto;

import de.frontsy.picciotto.convert.WorkbookToPoi;
import de.frontsy.picciotto.parse.css.PHCSSParser;
import de.frontsy.picciotto.parse.xml.CellParser;
import de.frontsy.picciotto.parse.xml.RowParser;
import de.frontsy.picciotto.parse.xml.XmlParser;
import de.frontsy.picciotto.structure.Workbook;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SpreadsheetGenerator {
    public static byte[] generate(String xml) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PHCSSParser cssParser = new PHCSSParser();
        CellParser cellParser = CellParser.builder().cssParser(cssParser).build();
        RowParser rowParser = RowParser.builder().cellParser(cellParser).build();
        XmlParser parser = XmlParser.builder().rowParser(rowParser).build();
        Optional<Workbook> workbook = parser.parse(xml);
        if (workbook.isPresent()) {
            XSSFWorkbook xssfWorkbook = WorkbookToPoi.workbookToXSSFWorkbook(workbook.orElseThrow());
            xssfWorkbook.write((OutputStream)stream);
        }
        return stream.toByteArray();
    }
}

