/*
 * Decompiled with CFR 0.152.
 */
package fm.sbt;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsSyncClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import fm.sbt.S3URLHandler$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ivy.util.CopyProgressEvent;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmv!B\u0001\u0003\u0011\u00039\u0011\u0001D*4+Jc\u0005*\u00198eY\u0016\u0014(BA\u0002\u0005\u0003\r\u0019(\r\u001e\u0006\u0002\u000b\u0005\u0011a-\\\u0002\u0001!\tA\u0011\"D\u0001\u0003\r\u0015Q!\u0001#\u0001\f\u00051\u00196'\u0016*M\u0011\u0006tG\r\\3s'\tIA\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'%!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAqAF\u0005C\u0002\u0013%q#A\u0007SK\u001eLwN\\'bi\u000eDWM]\u000b\u00021A\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\t[\u0006$8\r[5oO*\u0011QDD\u0001\u0005kRLG.\u0003\u0002 5\t)!+Z4fq\"1\u0011%\u0003Q\u0001\na\taBU3hS>tW*\u0019;dQ\u0016\u0014\b\u0005C\u0004$\u0013\u0001\u0007I\u0011\u0002\u0013\u00023\t,8m[3u\u0007J,G-\u001a8uS\u0006d7\u000f\u0015:pm&$WM]\u000b\u0002KA!QB\n\u00154\u0013\t9cBA\u0005Gk:\u001cG/[8ocA\u0011\u0011\u0006\r\b\u0003U9\u0002\"a\u000b\b\u000e\u00031R!!\f\u0004\u0002\rq\u0012xn\u001c;?\u0013\tyc\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003cI\u0012aa\u0015;sS:<'BA\u0018\u000f!\t!4(D\u00016\u0015\t1t'\u0001\u0003bkRD'B\u0001\u001d:\u0003%\tW.\u0019>p]\u0006<8OC\u0001;\u0003\r\u0019w.\\\u0005\u0003yU\u0012a#Q,T\u0007J,G-\u001a8uS\u0006d7\u000f\u0015:pm&$WM\u001d\u0005\b}%\u0001\r\u0011\"\u0003@\u0003u\u0011WoY6fi\u000e\u0013X\rZ3oi&\fGn\u001d)s_ZLG-\u001a:`I\u0015\fHC\u0001!D!\ti\u0011)\u0003\u0002C\u001d\t!QK\\5u\u0011\u001d!U(!AA\u0002\u0015\n1\u0001\u001f\u00132\u0011\u00191\u0015\u0002)Q\u0005K\u0005Q\"-^2lKR\u001c%/\u001a3f]RL\u0017\r\\:Qe>4\u0018\u000eZ3sA!)\u0001*\u0003C\u0001\u0013\u0006\t#/Z4jgR,'OQ;dW\u0016$8I]3eK:$\u0018.\u00197t!J|g/\u001b3feR\u0011\u0001I\u0013\u0005\u0006\u0017\u001e\u0003\r!J\u0001\taJ|g/\u001b3fe\")Q*\u0003C\u0001I\u0005ar-\u001a;Ck\u000e\\W\r^\"sK\u0012,g\u000e^5bYN\u0004&o\u001c<jI\u0016\u0014h\u0001B(\n\tA\u0013\u0011bU\u001aV%2KeNZ8\u0014\u00059\u000b\u0006C\u0001*`\u001d\t\u0019V,D\u0001U\u0015\t)f+A\u0002ve2T!!H,\u000b\u0005aK\u0016aA5ws*\u0011!lW\u0001\u0007CB\f7\r[3\u000b\u0003q\u000b1a\u001c:h\u0013\tqF+\u0001\u0006V%2C\u0015M\u001c3mKJL!\u0001Y1\u0003\u000fU\u0013F*\u00138g_*\u0011a\f\u0016\u0005\tG:\u0013\t\u0011)A\u0005I\u0006I\u0011M^1jY\u0006\u0014G.\u001a\t\u0003\u001b\u0015L!A\u001a\b\u0003\u000f\t{w\u000e\\3b]\"A\u0001N\u0014B\u0001B\u0003%\u0011.A\u0007d_:$XM\u001c;MK:<G\u000f\u001b\t\u0003\u001b)L!a\u001b\b\u0003\t1{gn\u001a\u0005\t[:\u0013\t\u0011)A\u0005S\u0006aA.Y:u\u001b>$\u0017NZ5fI\")1C\u0014C\u0001_R!\u0001O]:u!\t\th*D\u0001\n\u0011\u0015\u0019g\u000e1\u0001e\u0011\u0015Ag\u000e1\u0001j\u0011\u0015ig\u000e1\u0001j\u0011\u00151\u0018\u0002\"\u0003x\u0003\u0015j\u0017m[3Qe>\u0004XM\u001d;jKN4\u0015\u000e\\3De\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'\u000f\u0006\u0002ywB\u0011A'_\u0005\u0003uV\u0012\u0011\u0005\u0015:pa\u0016\u0014H/[3t\r&dWm\u0011:fI\u0016tG/[1mgB\u0013xN^5eKJDQ\u0001`;A\u0002!\n\u0001BZ5mK:\u000bW.\u001a\u0005\u0006}&!\ta`\u0001 I\u00164\u0017-\u001e7u\u0007J,G-\u001a8uS\u0006d7\u000f\u0015:pm&$WM]\"iC&tG\u0003BA\u0001\u0003\u000f\u00012\u0001NA\u0002\u0013\r\t)!\u000e\u0002\u001c\u0003^\u001b6I]3eK:$\u0018.\u00197t!J|g/\u001b3fe\u000eC\u0017-\u001b8\t\r\u0005%Q\u00101\u0001)\u0003\u0019\u0011WoY6fi\u001a)!B\u0001\u0002\u0002\u000eM1\u00111BA\b\u0003?\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0003mC:<'BAA\r\u0003\u0011Q\u0017M^1\n\t\u0005u\u00111\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007M\u000b\t#C\u0002\u0002$Q\u0013!\"\u0016*M\u0011\u0006tG\r\\3s\u0011\u001d\u0019\u00121\u0002C\u0001\u0003O!\"!!\u000b\u0011\u0007!\tY\u0001\u0003\u0006\u0002.\u0005-!\u0019!C\u0005\u0003_\t1#Y7bu>t7kM\"mS\u0016tGoQ1dQ\u0016,\"!!\r\u0011\u000f\u0005M\u00121\b\u0015\u0002@5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$\u0001\u0006d_:\u001cWO\u001d:f]RT1!HA\f\u0013\u0011\ti$!\u000e\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\u0005M\u001c$bAA%o\u0005A1/\u001a:wS\u000e,7/\u0003\u0003\u0002N\u0005\r#\u0001C!nCj|gnU\u001a\t\u0013\u0005E\u00131\u0002Q\u0001\n\u0005E\u0012\u0001F1nCj|gnU\u001aDY&,g\u000e^\"bG\",\u0007\u0005\u0003\u0006\u0002V\u0005-!\u0019!C\u0005\u0003/\n\u0011CY;dW\u0016$(+Z9vSJ,7oU*F+\t\tI\u0006\u0005\u0004\u00024\u0005m\u0002\u0006\u001a\u0005\n\u0003;\nY\u0001)A\u0005\u00033\n!CY;dW\u0016$(+Z9vSJ,7oU*FA!A\u0011\u0011MA\u0006\t\u0003\t\u0019'A\u0006jgJ+\u0017m\u00195bE2,Gc\u00013\u0002f!9Q+a\u0018A\u0002\u0005\u001d\u0004\u0003BA5\u0003_j!!a\u001b\u000b\t\u00055\u0014qC\u0001\u0004]\u0016$\u0018\u0002BA9\u0003W\u00121!\u0016*M\u0011!\t\t'a\u0003\u0005\u0002\u0005UD#\u00023\u0002x\u0005e\u0004bB+\u0002t\u0001\u0007\u0011q\r\u0005\t\u0003w\n\u0019\b1\u0001\u0002~\u00059A/[7f_V$\bcA\u0007\u0002\u0000%\u0019\u0011\u0011\u0011\b\u0003\u0007%sG\u000f\u0003\u0005\u0002\u0006\u0006-A\u0011AAD\u0003A9W\r^\"p]R,g\u000e\u001e'f]\u001e$\b\u000eF\u0002j\u0003\u0013Cq!VAB\u0001\u0004\t9\u0007\u0003\u0005\u0002\u0006\u0006-A\u0011AAG)\u0015I\u0017qRAI\u0011\u001d)\u00161\u0012a\u0001\u0003OB\u0001\"a\u001f\u0002\f\u0002\u0007\u0011Q\u0010\u0005\t\u0003+\u000bY\u0001\"\u0001\u0002\u0018\u0006yq-\u001a;MCN$Xj\u001c3jM&,G\rF\u0002j\u00033Cq!VAJ\u0001\u0004\t9\u0007\u0003\u0005\u0002\u0016\u0006-A\u0011AAO)\u0015I\u0017qTAQ\u0011\u001d)\u00161\u0014a\u0001\u0003OB\u0001\"a\u001f\u0002\u001c\u0002\u0007\u0011Q\u0010\u0005\t\u0003K\u000bY\u0001\"\u0001\u0002(\u0006Qq-\u001a;V%2KeNZ8\u0015\t\u0005%\u0016\u0011\u0019\t\u0004\u0003W{fbAAW;:!\u0011qVA`\u001d\u0011\t\t,!0\u000f\t\u0005M\u00161\u0018\b\u0005\u0003k\u000bILD\u0002,\u0003oK\u0011\u0001X\u0005\u00035nK!\u0001W-\n\u0005u9\u0016BA+W\u0011\u001d)\u00161\u0015a\u0001\u0003OB\u0001\"!2\u0002\f\u0011%\u0011qY\u0001\u0006I\u0016\u0014Wo\u001a\u000b\u0004\u0001\u0006%\u0007bBAf\u0003\u0007\u0004\r\u0001K\u0001\u0004[N<\u0007\u0002CAh\u0003\u0017!\t!!5\u0002-\u001d,Go\u0011:fI\u0016tG/[1mgB\u0013xN^5eKJ$2aMAj\u0011\u001d\tI!!4A\u0002!B\u0001\"a6\u0002\f\u0011\u0005\u0011\u0011\\\u0001\u0016O\u0016$\bK]8ys\u000e{gNZ5hkJ\fG/[8o+\t\tY\u000e\u0005\u0003\u0002^\u0006}W\"A\u001c\n\u0007\u0005\u0005xGA\nDY&,g\u000e^\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0005\u0002f\u0006-A\u0011AAt\u0003U9W\r^\"mS\u0016tGOQ;dW\u0016$\u0018I\u001c3LKf$B!!;\u0002pB9Q\"a;\u0002@!B\u0013bAAw\u001d\t1A+\u001e9mKNBq!VAr\u0001\u0004\t9\u0007\u0003\u0005\u0002&\u0006-A\u0011AAz)\u0019\tI+!>\u0002x\"9Q+!=A\u0002\u0005\u001d\u0004\u0002CA>\u0003c\u0004\r!! \t\u0011\u0005m\u00181\u0002C\u0001\u0003{\f!b\u001c9f]N#(/Z1n)\u0011\tyPa\u0003\u0011\t\t\u0005!qA\u0007\u0003\u0005\u0007QAA!\u0002\u0002\u0018\u0005\u0011\u0011n\\\u0005\u0005\u0005\u0013\u0011\u0019AA\u0006J]B,Ho\u0015;sK\u0006l\u0007bB+\u0002z\u0002\u0007\u0011q\r\u0005\t\u0005\u001f\tY\u0001\"\u0001\u0003\u0012\u0005!A.[:u)\u0011\u0011\u0019B!\n\u0011\r\tU!qDA4\u001d\u0011\u00119Ba\u0007\u000f\u0007-\u0012I\"C\u0001\u0010\u0013\r\u0011iBD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\tCa\t\u0003\u0007M+\u0017OC\u0002\u0003\u001e9Aq!\u0016B\u0007\u0001\u0004\t9\u0007\u0003\u0005\u0003*\u0005-A\u0011\u0001B\u0016\u0003!!wn\u001e8m_\u0006$Gc\u0002!\u0003.\tE\"1\b\u0005\t\u0005_\u00119\u00031\u0001\u0002h\u0005\u00191O]2\t\u0011\tM\"q\u0005a\u0001\u0005k\tA\u0001Z3tiB!!\u0011\u0001B\u001c\u0013\u0011\u0011IDa\u0001\u0003\t\u0019KG.\u001a\u0005\t\u0005{\u00119\u00031\u0001\u0003@\u0005\tA\u000e\u0005\u0003\u0003B\t\rS\"\u0001,\n\u0007\t\u0015cK\u0001\u000bD_BL\bK]8he\u0016\u001c8\u000fT5ti\u0016tWM\u001d\u0005\t\u0005\u0013\nY\u0001\"\u0001\u0003L\u00051Q\u000f\u001d7pC\u0012$r\u0001\u0011B'\u0005\u001f\u0012\t\u0006\u0003\u0005\u00030\t\u001d\u0003\u0019\u0001B\u001b\u0011!\u0011\u0019Da\u0012A\u0002\u0005\u001d\u0004\u0002\u0003B\u001f\u0005\u000f\u0002\rAa\u0010\t\u0011\tU\u00131\u0002C\u0001\u0005/\n\u0001c]3u%\u0016\fX/Z:u\u001b\u0016$\bn\u001c3\u0015\u0007\u0001\u0013I\u0006\u0003\u0005\u0003\\\tM\u0003\u0019AA?\u00035\u0011X-];fgRlU\r\u001e5pI\"A!qLA\u0006\t\u0003\u0011\t'A\u0005hKR\u0014VmZ5p]R1!1\rB8\u0005c\u0002BA!\u001a\u0003l5\u0011!q\r\u0006\u0004\u0005S:\u0014a\u0002:fO&|gn]\u0005\u0005\u0005[\u00129GA\u0004SK\u001eLwN\\:\t\u000fU\u0013i\u00061\u0001\u0002h!9\u0011\u0011\u0002B/\u0001\u0004A\u0003\u0002\u0003B;\u0003\u0017!\tAa\u001e\u0002)\u001d,GOU3hS>tg*Y7f\rJ|W.\u0016*M)\u0011\u0011IHa \u0011\t5\u0011Y\bK\u0005\u0004\u0005{r!AB(qi&|g\u000eC\u0004V\u0005g\u0002\r!a\u001a\t\u0011\t\r\u00151\u0002C\u0001\u0005\u000b\u000bAcZ3u%\u0016<\u0017n\u001c8OC6,gI]8n\t:\u001bF\u0003\u0002B=\u0005\u000fCq!!\u0003\u0003\u0002\u0002\u0007\u0001\u0006\u0003\u0005\u0003\f\u0006-A\u0011\u0001BG\u0003=9W\r\u001e\"vG.,G/\u00118e\u0017\u0016LH\u0003\u0002BH\u0005+\u0003R!\u0004BIQ!J1Aa%\u000f\u0005\u0019!V\u000f\u001d7fe!9QK!#A\u0002\u0005\u001d\u0004\u0002\u0003BM\u0003\u0017!\tAa'\u0002\u001d\u001d,G/Q7bu>t7kM+S\u0013R!!Q\u0014BS!\u0015i!1\u0010BP!\u0011\t\tE!)\n\t\t\r\u00161\t\u0002\f\u00036\f'p\u001c8TgU\u0013\u0016\nC\u0004\u0003(\n]\u0005\u0019\u0001\u0015\u0002\u0007U\u0014\u0018\u000e\u0003\u0005\u0003\u001a\u0006-A\u0011\u0001BV)\u0011\u0011iJ!,\t\u000fU\u0013I\u000b1\u0001\u0002h!A!\u0011TA\u0006\t\u0003\u0011\t\f\u0006\u0003\u0003\u001e\nM\u0006\u0002\u0003BT\u0005_\u0003\rA!.\u0011\t\u0005%$qW\u0005\u0005\u0005s\u000bYGA\u0002V%&\u0003")
public final class S3URLHandler
implements URLHandler {
    private final ConcurrentHashMap<String, AmazonS3> amazonS3ClientCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Object> bucketRequiresSSE = new ConcurrentHashMap();

    public static AWSCredentialsProviderChain defaultCredentialsProviderChain(String string) {
        return S3URLHandler$.MODULE$.defaultCredentialsProviderChain(string);
    }

    public static Function1<String, AWSCredentialsProvider> getBucketCredentialsProvider() {
        return S3URLHandler$.MODULE$.getBucketCredentialsProvider();
    }

    public static void registerBucketCredentialsProvider(Function1<String, AWSCredentialsProvider> function1) {
        S3URLHandler$.MODULE$.registerBucketCredentialsProvider(function1);
    }

    private ConcurrentHashMap<String, AmazonS3> amazonS3ClientCache() {
        return this.amazonS3ClientCache;
    }

    private ConcurrentHashMap<String, Object> bucketRequiresSSE() {
        return this.bucketRequiresSSE;
    }

    public boolean isReachable(URL url) {
        return this.getURLInfo(url).isReachable();
    }

    public boolean isReachable(URL url, int timeout) {
        return this.getURLInfo(url, timeout).isReachable();
    }

    public long getContentLength(URL url) {
        return this.getURLInfo(url).getContentLength();
    }

    public long getContentLength(URL url, int timeout) {
        return this.getURLInfo(url, timeout).getContentLength();
    }

    public long getLastModified(URL url) {
        return this.getURLInfo(url).getLastModified();
    }

    public long getLastModified(URL url, int timeout) {
        return this.getURLInfo(url, timeout).getLastModified();
    }

    public URLHandler.URLInfo getURLInfo(URL url) {
        return this.getURLInfo(url, 0);
    }

    private void debug(String msg) {
        Message.debug((String)("S3URLHandler." + msg));
    }

    /*
     * WARNING - void declaration
     */
    public AWSCredentialsProvider getCredentialsProvider(String bucket) {
        void var2_3;
        AWSCredentialsProvider aWSCredentialsProvider;
        Message.info((String)("S3URLHandler - Looking up AWS Credentials for bucket: " + bucket + " ..."));
        try {
            aWSCredentialsProvider = (AWSCredentialsProvider)S3URLHandler$.MODULE$.getBucketCredentialsProvider().apply((Object)bucket);
        }
        catch (AmazonClientException ex) {
            Message.error((String)"Unable to find AWS Credentials.");
            throw ex;
        }
        AWSCredentialsProvider credentialsProvider = aWSCredentialsProvider;
        Message.info((String)("S3URLHandler - Using AWS Access Key Id: " + credentialsProvider.getCredentials().getAWSAccessKeyId() + " for bucket: " + bucket));
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public ClientConfiguration getProxyConfiguration() {
        void var1_1;
        ClientConfiguration configuration = new ClientConfiguration();
        Option$.MODULE$.apply((Object)System.getProperty("https.proxyHost")).foreach((Function1 & Serializable & scala.Serializable)proxyHost -> {
            S3URLHandler.$anonfun$getProxyConfiguration$1(configuration, proxyHost);
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple3<AmazonS3, String, String> getClientBucketAndKey(URL url) {
        void var4_4;
        void var3_3;
        Tuple2<String, String> tuple2 = this.getBucketAndKey(url);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String bucket = (String)tuple2._1();
        String key = (String)tuple2._2();
        void bucket2 = var3_3;
        void key2 = var4_4;
        AmazonS3 client = this.amazonS3ClientCache().get(bucket2);
        if (client == null) {
            client = (AmazonS3)((AwsSyncClientBuilder)AmazonS3Client.builder().withCredentials(this.getCredentialsProvider((String)bucket2)).withClientConfiguration(this.getProxyConfiguration()).withRegion(this.getRegion(url, (String)bucket2))).build();
            this.amazonS3ClientCache().put((String)bucket2, client);
            Message.info((String)("S3URLHandler - Created S3 Client for bucket: " + (String)bucket2 + " and region: " + client.getRegionName()));
        }
        return new Tuple3((Object)client, (Object)bucket2, (Object)key2);
    }

    /*
     * WARNING - void declaration
     */
    public URLHandler.URLInfo getURLInfo(URL url, int timeout) {
        try {
            void var7_6;
            void var6_5;
            void var5_4;
            this.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getURLInfo(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, BoxesRunTime.boxToInteger((int)timeout)})));
            Tuple3<AmazonS3, String, String> tuple3 = this.getClientBucketAndKey(url);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            AmazonS3 client = (AmazonS3)tuple3._1();
            String bucket = (String)tuple3._2();
            String key = (String)tuple3._3();
            void client2 = var5_4;
            void bucket2 = var6_5;
            void key2 = var7_6;
            ObjectMetadata meta = client2.getObjectMetadata((String)bucket2, (String)key2);
            boolean available = true;
            long contentLength = meta.getContentLength();
            long lastModified = meta.getLastModified().getTime();
            return new S3URLInfo(available, contentLength, lastModified);
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof AmazonS3Exception) || ((AmazonS3Exception)throwable).getStatusCode() != 404) {
                throw throwable;
            }
            URLHandler.URLInfo uRLInfo = URLHandler.UNAVAILABLE;
            return uRLInfo;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream openStream(URL url) {
        void var5_5;
        void var4_4;
        void var3_3;
        this.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"openStream(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        Tuple3<AmazonS3, String, String> tuple3 = this.getClientBucketAndKey(url);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        AmazonS3 client = (AmazonS3)tuple3._1();
        String bucket = (String)tuple3._2();
        String key = (String)tuple3._3();
        void client2 = var3_3;
        void bucket2 = var4_4;
        void key2 = var5_5;
        return client2.getObject((String)bucket2, (String)key2).getObjectContent();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<URL> list(URL url) {
        void var5_5;
        void var4_4;
        void var3_3;
        this.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        Tuple3<AmazonS3, String, String> tuple3 = this.getClientBucketAndKey(url);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        AmazonS3 client = (AmazonS3)tuple3._1();
        String bucket = (String)tuple3._2();
        String key = (String)tuple3._3();
        void client2 = var3_3;
        void bucket2 = var4_4;
        void key2 = var5_5;
        String prefix = new StringOps(Predef$.MODULE$.augmentString((String)key2)).stripSuffix("/") + "/";
        ListObjectsRequest request = new ListObjectsRequest().withBucketName((String)bucket2).withPrefix(prefix).withDelimiter("/");
        ObjectListing listing = client2.listObjects(request);
        Predef$.MODULE$.require(!listing.isTruncated(), (Function0 & Serializable & scala.Serializable)() -> "Truncated ObjectListing!  Making additional calls currently isn't implemented!");
        Seq res = (Seq)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(listing.getCommonPrefixes()).asScala()).$plus$plus((GenTraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(listing.getObjectSummaries()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getKey(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)k -> new URL(new StringOps(Predef$.MODULE$.augmentString(url.toString())).stripSuffix("/") + "/" + new StringOps(Predef$.MODULE$.augmentString(k)).stripPrefix(prefix)), Seq$.MODULE$.canBuildFrom());
        this.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list(", ") => \\n  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})) + res.mkString("\n  "));
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public void download(URL src, File dest, CopyProgressListener l) {
        void var7_7;
        void var6_6;
        void var5_5;
        this.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"download(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{src, dest})));
        Tuple3<AmazonS3, String, String> tuple3 = this.getClientBucketAndKey(src);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        AmazonS3 client = (AmazonS3)tuple3._1();
        String bucket = (String)tuple3._2();
        String key = (String)tuple3._3();
        void client2 = var5_5;
        void bucket2 = var6_6;
        void key2 = var7_7;
        CopyProgressEvent event = new CopyProgressEvent();
        if (l != null) {
            l.start(event);
        }
        ObjectMetadata meta = client2.getObject(new GetObjectRequest((String)bucket2, (String)key2), dest);
        dest.setLastModified(meta.getLastModified().getTime());
        if (l != null) {
            l.end(event);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void upload(File src, URL dest, CopyProgressListener l) {
        void var8_8;
        void var7_7;
        void var6_6;
        Tuple3<AmazonS3, String, String> tuple3;
        this.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"upload(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{src, dest})));
        CopyProgressEvent event = new CopyProgressEvent();
        if (l != null) {
            l.start(event);
        }
        if ((tuple3 = this.getClientBucketAndKey(dest)) == null) {
            throw new MatchError(tuple3);
        }
        AmazonS3 client = (AmazonS3)tuple3._1();
        String bucket = (String)tuple3._2();
        String key = (String)tuple3._3();
        void client2 = var6_6;
        void bucket2 = var7_7;
        void key2 = var8_8;
        if (this.bucketRequiresSSE().containsKey(bucket2)) {
            S3URLHandler.putImpl$1(true, src, (AmazonS3)client2, (String)bucket2, (String)key2);
        } else {
            try {
                S3URLHandler.putImpl$1(false, src, (AmazonS3)client2, (String)bucket2, (String)key2);
            }
            catch (Throwable throwable) {
                if (throwable instanceof AmazonS3Exception && ((AmazonS3Exception)throwable).getStatusCode() == 403) {
                    this.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"upload(", ", ", ") failed with a 403 status code.  Retrying with Server Side Encryption Enabled."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{src, dest})));
                    S3URLHandler.putImpl$1(true, src, (AmazonS3)client2, (String)bucket2, (String)key2);
                    this.bucketRequiresSSE().put((String)bucket2, BoxesRunTime.boxToBoolean((boolean)true));
                    Message.info((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"S3URLHandler - Enabled Server Side Encryption (SSE) for bucket: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket2})));
                }
                throw throwable;
            }
        }
        if (l != null) {
            l.end(event);
        }
    }

    public void setRequestMethod(int requestMethod) {
        this.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"setRequestMethod(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)requestMethod)})));
    }

    public Regions getRegion(URL url, String bucket) {
        return (Regions)this.getRegionNameFromURL(url).orElse((Function0 & Serializable & scala.Serializable)() -> this.getRegionNameFromDNS(bucket)).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)Regions.getCurrentRegion()).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getName())).map((Function1 & Serializable & scala.Serializable)x$1 -> Regions.fromName((String)x$1)).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> Option$.MODULE$.apply(x$11)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Regions.DEFAULT_REGION);
    }

    public Option<String> getRegionNameFromURL(URL url) {
        return this.getAmazonS3URI(url).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.getRegion()).flatMap((Function1 & Serializable & scala.Serializable)x$13 -> Option$.MODULE$.apply(x$13)).orElse((Function0 & Serializable & scala.Serializable)() -> S3URLHandler$.MODULE$.fm$sbt$S3URLHandler$$RegionMatcher().findFirstIn((CharSequence)url.toString()));
    }

    public Option<String> getRegionNameFromDNS(String bucket) {
        String canonicalHostName = InetAddress.getByName(bucket + ".s3.amazonaws.com").getCanonicalHostName();
        return S3URLHandler$.MODULE$.fm$sbt$S3URLHandler$$RegionMatcher().findFirstIn((CharSequence)canonicalHostName);
    }

    public Tuple2<String, String> getBucketAndKey(URL url) {
        return (Tuple2)this.getAmazonS3URI(url).map((Function1 & Serializable & scala.Serializable)amzn -> new Tuple2((Object)amzn.getBucket(), (Object)amzn.getKey())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)url.getHost(), (Object)new StringOps(Predef$.MODULE$.augmentString(url.getPath())).stripPrefix("/")));
    }

    public Option<AmazonS3URI> getAmazonS3URI(String uri) {
        return this.getAmazonS3URI(URI.create(uri));
    }

    public Option<AmazonS3URI> getAmazonS3URI(URL url) {
        return this.getAmazonS3URI(url.toURI());
    }

    public Option<AmazonS3URI> getAmazonS3URI(URI uri) {
        try {
            URI httpsURI = uri.getScheme() == null ? new URI("https://" + uri) : new URI("https", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            return new Some((Object)new AmazonS3URI(httpsURI));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return None$.MODULE$;
        }
    }

    public static final /* synthetic */ void $anonfun$getProxyConfiguration$1(ClientConfiguration configuration$1, String proxyHost) {
        Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(System.getProperty("https.proxyPort"))).toInt())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)proxyPort -> {
            configuration$1.setProxyHost(proxyHost);
            configuration$1.setProxyPort(proxyPort);
        });
    }

    private static final PutObjectResult putImpl$1(boolean serverSideEncryption, File src$1, AmazonS3 client$1, String bucket$2, String key$1) {
        ObjectMetadata meta = new ObjectMetadata();
        if (serverSideEncryption) {
            meta.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        }
        return client$1.putObject(new PutObjectRequest(bucket$2, key$1, src$1).withMetadata(meta));
    }

    public static class S3URLInfo
    extends URLHandler.URLInfo {
        public S3URLInfo(boolean available, long contentLength, long lastModified) {
            super(available, contentLength, lastModified);
        }
    }
}

