package fm.sbt

import com.amazonaws.auth.{AWSCredentials, AWSCredentialsProvider, BasicSessionCredentials}

import scala.io.Source

class LiveAWSCredentialsProvider() extends AWSCredentialsProvider {

  def getCredentials: AWSCredentials = {
    val userHome = System.getProperty("user.home")
    val credFile = Source.fromFile(s"$userHome/.aws/credentials").getLines.toList
    val start = credFile.indexOf("[live]")

    val accessKey = credFile(start + 2).split(" = ").last
    val secretKey = credFile(start + 3).split(" = ").last
    val sessionToken = credFile(start + 4).split(" = ").last

    new BasicSessionCredentials(accessKey, secretKey, sessionToken)
  }

  def refresh() {}

  override def toString: String = {
    this.getClass.getSimpleName
  }
}