/*
 * Decompiled with CFR 0.152.
 */
package io.adminshell.aas.v3.dataformat.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import io.adminshell.aas.v3.dataformat.core.ReflectionHelper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ReflectionAnnotationIntrospector
extends JacksonAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private static final String MODEL_TYPE_PROPERTY = "modelType";
    private static final String GETTER_PREFIX = "get";

    @Override
    public String findTypeName(AnnotatedClass ac) {
        String customType = ReflectionHelper.getModelType(ac.getRawType());
        return customType != null ? customType : super.findTypeName(ac);
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass ac, JavaType baseType) {
        String modelType = ReflectionHelper.getModelType(ac.getRawType());
        if (modelType != null) {
            StdTypeResolverBuilder result = this._constructStdTypeResolverBuilder();
            result = result.init(JsonTypeInfo.Id.NAME, null);
            result.inclusion(JsonTypeInfo.As.PROPERTY);
            result.typeProperty(MODEL_TYPE_PROPERTY);
            result.typeIdVisibility(false);
            return result;
        }
        return super.findTypeResolver(config, ac, baseType);
    }

    @Override
    public List<NamedType> findSubtypes(Annotated a) {
        if (ReflectionHelper.SUBTYPES.containsKey(a.getRawType()) && !ReflectionHelper.SUBTYPES.get(a.getRawType()).isEmpty()) {
            return ReflectionHelper.SUBTYPES.get(a.getRawType()).stream().map(x -> new NamedType((Class<?>)x, x.getSimpleName())).collect(Collectors.toList());
        }
        return super.findSubtypes(a);
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(Annotated a) {
        AnnotatedMethod method;
        JsonInclude.Value result = super.findPropertyInclusion(a);
        if (result != JsonInclude.Value.empty()) {
            return result;
        }
        if (AnnotatedMethod.class.isAssignableFrom(a.getClass()) && (method = (AnnotatedMethod)a).getParameterCount() == 0 && method.getName().startsWith(GETTER_PREFIX) && Collection.class.isAssignableFrom(method.getRawReturnType()) && ReflectionHelper.isModelInterfaceOrDefaultImplementation(method.getDeclaringClass())) {
            return result.withValueInclusion(JsonInclude.Include.NON_EMPTY);
        }
        return result;
    }
}

