/*
 * Decompiled with CFR 0.152.
 */
package io.adminshell.aas.v3.dataformat.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.adminshell.aas.v3.dataformat.SerializationException;
import io.adminshell.aas.v3.dataformat.Serializer;
import io.adminshell.aas.v3.dataformat.core.ReflectionHelper;
import io.adminshell.aas.v3.dataformat.core.serialization.EmbeddedDataSpecificationSerializer;
import io.adminshell.aas.v3.dataformat.core.serialization.EnumSerializer;
import io.adminshell.aas.v3.dataformat.json.ReferableSerializer;
import io.adminshell.aas.v3.dataformat.json.ReflectionAnnotationIntrospector;
import io.adminshell.aas.v3.dataformat.json.modeltype.ModelTypeProcessor;
import io.adminshell.aas.v3.model.AssetAdministrationShellEnvironment;
import io.adminshell.aas.v3.model.EmbeddedDataSpecification;
import io.adminshell.aas.v3.model.Referable;
import java.util.List;

public class JsonSerializer
implements Serializer,
ReferableSerializer {
    protected JsonMapper mapper;

    public JsonSerializer() {
        this.buildMapper();
    }

    protected void buildMapper() {
        this.mapper = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(SerializationFeature.INDENT_OUTPUT)).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)).serializationInclusion(JsonInclude.Include.NON_NULL)).addModule(this.buildEnumModule())).addModule(this.buildCustomSerializerModule())).annotationIntrospector(new ReflectionAnnotationIntrospector())).build();
        ReflectionHelper.JSON_MIXINS.entrySet().forEach(x -> this.mapper.addMixIn((Class)x.getKey(), (Class)x.getValue()));
    }

    protected SimpleModule buildCustomSerializerModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(EmbeddedDataSpecification.class, new EmbeddedDataSpecificationSerializer());
        return module;
    }

    protected SimpleModule buildEnumModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Enum.class, new EnumSerializer());
        return module;
    }

    @Override
    public String write(AssetAdministrationShellEnvironment aasEnvironment) throws SerializationException {
        try {
            return this.mapper.writeValueAsString(ModelTypeProcessor.postprocess(this.mapper.valueToTree(aasEnvironment)));
        }
        catch (JsonProcessingException ex) {
            throw new SerializationException("error serializing AssetAdministrationShellEnvironment", ex);
        }
    }

    @Override
    public String write(Referable referable) throws SerializationException {
        try {
            return this.mapper.writeValueAsString(ModelTypeProcessor.postprocess(this.mapper.valueToTree(referable)));
        }
        catch (JsonProcessingException ex) {
            throw new SerializationException("error serializing Referable", ex);
        }
    }

    @Override
    public String write(List<Referable> referables) throws SerializationException {
        if (referables.isEmpty()) {
            return null;
        }
        try {
            ObjectWriter objectWriter = this.mapper.writerFor(this.mapper.getTypeFactory().constructCollectionType(List.class, referables.get(0).getClass()));
            String json = objectWriter.writeValueAsString(referables);
            return this.mapper.writeValueAsString(ModelTypeProcessor.postprocess(this.mapper.readTree(json)));
        }
        catch (JsonProcessingException ex) {
            throw new SerializationException("error serializing list of Referables", ex);
        }
    }
}

