/*
 * Decompiled with CFR 0.152.
 */
package io.adminshell.aas.v3.dataformat.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.adminshell.aas.v3.dataformat.DeserializationException;
import io.adminshell.aas.v3.dataformat.Deserializer;
import io.adminshell.aas.v3.dataformat.core.ReflectionHelper;
import io.adminshell.aas.v3.dataformat.core.deserialization.EmbeddedDataSpecificationDeserializer;
import io.adminshell.aas.v3.dataformat.core.deserialization.EnumDeserializer;
import io.adminshell.aas.v3.dataformat.json.ReferableDeserializer;
import io.adminshell.aas.v3.dataformat.json.ReflectionAnnotationIntrospector;
import io.adminshell.aas.v3.dataformat.json.modeltype.ModelTypeProcessor;
import io.adminshell.aas.v3.model.AssetAdministrationShellEnvironment;
import io.adminshell.aas.v3.model.EmbeddedDataSpecification;
import io.adminshell.aas.v3.model.Referable;
import java.util.List;
import java.util.Map;

public class JsonDeserializer
implements Deserializer,
ReferableDeserializer {
    protected JsonMapper mapper;
    protected SimpleAbstractTypeResolver typeResolver;
    protected static Map<Class<?>, com.fasterxml.jackson.databind.JsonDeserializer> customDeserializers = Map.of(EmbeddedDataSpecification.class, new EmbeddedDataSpecificationDeserializer());

    public JsonDeserializer() {
        this.initTypeResolver();
        this.buildMapper();
    }

    protected void buildMapper() {
        this.mapper = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).annotationIntrospector(new ReflectionAnnotationIntrospector())).addModule(this.buildEnumModule())).addModule(this.buildImplementationModule())).addModule(this.buildCustomDeserializerModule())).build();
        ReflectionHelper.JSON_MIXINS.entrySet().forEach(x -> this.mapper.addMixIn((Class)x.getKey(), (Class)x.getValue()));
    }

    protected SimpleModule buildCustomDeserializerModule() {
        SimpleModule module = new SimpleModule();
        customDeserializers.forEach(module::addDeserializer);
        return module;
    }

    private void initTypeResolver() {
        this.typeResolver = new SimpleAbstractTypeResolver();
        ReflectionHelper.DEFAULT_IMPLEMENTATIONS.stream().filter(x -> !customDeserializers.containsKey(x.getInterfaceType())).forEach(x -> this.typeResolver.addMapping(x.getInterfaceType(), x.getImplementationType()));
    }

    protected SimpleModule buildEnumModule() {
        SimpleModule module = new SimpleModule();
        ReflectionHelper.ENUMS.forEach(x -> module.addDeserializer(x, new EnumDeserializer(x)));
        return module;
    }

    protected SimpleModule buildImplementationModule() {
        SimpleModule module = new SimpleModule();
        module.setAbstractTypes(this.typeResolver);
        return module;
    }

    @Override
    public AssetAdministrationShellEnvironment read(String value) throws DeserializationException {
        try {
            return this.mapper.treeToValue((TreeNode)ModelTypeProcessor.preprocess(value), AssetAdministrationShellEnvironment.class);
        }
        catch (JsonProcessingException ex) {
            throw new DeserializationException("error deserializing AssetAdministrationShellEnvironment", ex);
        }
    }

    @Override
    public <T> void useImplementation(Class<T> aasInterface, Class<? extends T> implementation) {
        this.typeResolver.addMapping(aasInterface, implementation);
        this.buildMapper();
    }

    @Override
    public <T extends Referable> T readReferable(String referable, Class<T> outputClass) throws DeserializationException {
        try {
            return (T)((Referable)this.mapper.treeToValue((TreeNode)ModelTypeProcessor.preprocess(referable), outputClass));
        }
        catch (JsonProcessingException ex) {
            throw new DeserializationException("error deserializing Referable", ex);
        }
    }

    @Override
    public <T extends Referable> List<T> readReferables(String referables, Class<T> outputClass) throws DeserializationException {
        try {
            String parsed = this.mapper.writeValueAsString(ModelTypeProcessor.preprocess(referables));
            return (List)this.mapper.readValue(parsed, new TypeReference<List<T>>(){});
        }
        catch (JsonProcessingException ex) {
            throw new DeserializationException("error deserializing list of Referable", ex);
        }
    }
}

