/*
 * Decompiled with CFR 0.152.
 */
package io.adminshell.aas.v3.dataformat.core.util;

import com.google.common.base.Objects;
import com.google.common.reflect.TypeToken;
import io.adminshell.aas.v3.dataformat.core.ReflectionHelper;
import io.adminshell.aas.v3.dataformat.core.util.IdentifiableCollector;
import io.adminshell.aas.v3.dataformat.core.util.MostSpecificTypeTokenComparator;
import io.adminshell.aas.v3.model.AssetAdministrationShell;
import io.adminshell.aas.v3.model.AssetAdministrationShellEnvironment;
import io.adminshell.aas.v3.model.Identifiable;
import io.adminshell.aas.v3.model.Key;
import io.adminshell.aas.v3.model.KeyElements;
import io.adminshell.aas.v3.model.KeyType;
import io.adminshell.aas.v3.model.ModelingKind;
import io.adminshell.aas.v3.model.Operation;
import io.adminshell.aas.v3.model.Referable;
import io.adminshell.aas.v3.model.Reference;
import io.adminshell.aas.v3.model.Submodel;
import io.adminshell.aas.v3.model.impl.DefaultKey;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AasUtils {
    private static final Logger log = LoggerFactory.getLogger(AasUtils.class);
    private static final char UNDERSCORE = '_';
    private static final String KEY_REGEX_GROUP_TYPE = "type";
    private static final String KEY_REGEX_GROUP_ID_TYPE = "idtype";
    private static final String KEY_REGEX_GROUP_VALUE = "value";
    private static final Pattern KEY_REGEX = Pattern.compile(String.format("\\((?<%s>\\w+)\\)\\[(?<%s>\\w+)\\](?<%s>.*)", "type", "idtype", "value"));

    private AasUtils() {
    }

    public static String asString(Reference reference) {
        if (reference == null) {
            return null;
        }
        return reference.getKeys().stream().map(x -> String.format("(%s)[%s]%s", AasUtils.serializeEnumName(x.getType().name()), AasUtils.serializeEnumName(x.getIdType().name()), x.getValue())).collect(Collectors.joining(","));
    }

    public static Reference parseReference(String value) {
        return AasUtils.parseReference(value, ReflectionHelper.getDefaultImplementation(Reference.class), ReflectionHelper.getDefaultImplementation(Key.class));
    }

    public static Reference parseReference(String value, Class<? extends Reference> referenceType, Class<? extends Key> keyType) {
        if (value == null || value.isBlank()) {
            return null;
        }
        try {
            Reference result = referenceType.getConstructor(new Class[0]).newInstance(new Object[0]);
            result.setKeys(Stream.of(value.split(",")).map(x -> AasUtils.parseKey(x)).collect(Collectors.toList()));
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalArgumentException("error parsing reference - could not instantiate reference type", ex);
        }
    }

    public static PropertyDescriptor getProperty(Object parent, String propertyName) {
        if (parent == null || propertyName == null || propertyName.isBlank()) {
            return null;
        }
        return AasUtils.getAasProperties(parent.getClass()).stream().filter(x -> x.getName().equals(propertyName)).findAny().orElse(null);
    }

    public static Class<?> getCollectionContentType(Type genericCollectionType) {
        return TypeToken.of(genericCollectionType).resolveType(Collection.class.getTypeParameters()[0]).getRawType();
    }

    public static PropertyDescriptor getProperty(Class<?> type, String propertyName) {
        if (type == null || propertyName == null || propertyName.isBlank()) {
            return null;
        }
        return AasUtils.getAasProperties(type).stream().filter(x -> x.getName().equals(propertyName)).findAny().orElse(null);
    }

    public static Key parseKey(String value) {
        Matcher matcher = KEY_REGEX.matcher(value);
        if (matcher.find()) {
            KeyElements keyElements = KeyElements.valueOf(AasUtils.deserializeEnumName(matcher.group(KEY_REGEX_GROUP_TYPE)));
            KeyType keyType = KeyType.valueOf(AasUtils.deserializeEnumName(matcher.group(KEY_REGEX_GROUP_ID_TYPE)));
            return (Key)((DefaultKey.Builder)((DefaultKey.Builder)((DefaultKey.Builder)new DefaultKey.Builder().type(keyElements)).idType(keyType)).value(matcher.group(KEY_REGEX_GROUP_VALUE))).build();
        }
        return null;
    }

    public static boolean isLocal(Reference reference, AssetAdministrationShellEnvironment environment) {
        return !reference.getKeys().stream().anyMatch(x -> x.getType() == KeyElements.GLOBAL_REFERENCE);
    }

    public static List<Submodel> getSubmodelTemplates(AssetAdministrationShell aas, AssetAdministrationShellEnvironment environment) {
        return aas.getSubmodels().stream().map(ref -> AasUtils.resolve(ref, environment, Submodel.class)).filter(sm -> sm != null).filter(sm -> sm.getKind() != ModelingKind.INSTANCE).collect(Collectors.toList());
    }

    public static boolean hasTemplate(AssetAdministrationShell aas, AssetAdministrationShellEnvironment environment) {
        return !AasUtils.getSubmodelTemplates(aas, environment).isEmpty();
    }

    public static Reference toReference(Identifiable identifiable, Class<? extends Reference> referenceType, Class<? extends Key> keyType) {
        try {
            Reference reference = referenceType.getConstructor(new Class[0]).newInstance(new Object[0]);
            Key key = keyType.getConstructor(new Class[0]).newInstance(new Object[0]);
            key.setType(AasUtils.referableToKeyType(identifiable));
            key.setIdType(KeyType.valueOf(identifiable.getIdentification().getIdType().toString()));
            key.setValue(identifiable.getIdentification().getIdentifier());
            reference.setKeys(List.of(key));
            return reference;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalArgumentException("error parsing reference - could not instantiate reference type", ex);
        }
    }

    public static Reference toReference(Identifiable identifiable) {
        return AasUtils.toReference(identifiable, ReflectionHelper.getDefaultImplementation(Reference.class), ReflectionHelper.getDefaultImplementation(Key.class));
    }

    public static KeyElements referableToKeyType(Referable referable) {
        Class<?> aasInterface = ReflectionHelper.getAasInterface(referable.getClass());
        if (aasInterface != null) {
            return KeyElements.valueOf(AasUtils.deserializeEnumName(aasInterface.getSimpleName()));
        }
        return null;
    }

    public static String serializeEnumName(String input) {
        Object result = "";
        boolean capitalize = true;
        for (int i = 0; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if ('_' == currentChar) {
                capitalize = true;
                continue;
            }
            result = (String)result + (capitalize ? currentChar : Character.toLowerCase(currentChar));
            capitalize = false;
        }
        return result;
    }

    public static String deserializeEnumName(String input) {
        Object result = "";
        if (input == null || input.isEmpty()) {
            return result;
        }
        result = (String)result + input.charAt(0);
        for (int i = 1; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (Character.isUpperCase(currentChar)) {
                result = (String)result + "_";
            }
            result = (String)result + Character.toUpperCase(currentChar);
        }
        return result;
    }

    public static Class<?> keyTypeToClass(KeyElements key) {
        return Stream.concat(ReflectionHelper.INTERFACES.stream(), ReflectionHelper.INTERFACES_WITHOUT_DEFAULT_IMPLEMENTATION.stream()).filter(x -> x.getSimpleName().equals(AasUtils.serializeEnumName(key.name()))).findAny().orElse(null);
    }

    public static Reference toReference(Reference parent, Referable element, Class<? extends Reference> referenceType, Class<? extends Key> keyType) {
        if (element == null) {
            return null;
        }
        if (Identifiable.class.isAssignableFrom(element.getClass())) {
            return AasUtils.toReference((Identifiable)element, referenceType, keyType);
        }
        Reference result = AasUtils.clone(parent, referenceType, keyType);
        if (result != null) {
            try {
                Key newKey = keyType.getConstructor(new Class[0]).newInstance(new Object[0]);
                newKey.setType(AasUtils.referableToKeyType(element));
                newKey.setIdType(KeyType.ID_SHORT);
                newKey.setValue(element.getIdShort());
                result.getKeys().add(newKey);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new IllegalArgumentException("error parsing reference - could not instantiate reference type", ex);
            }
        }
        return result;
    }

    public static Reference toReference(Reference parent, Referable element) {
        return AasUtils.toReference(parent, element, ReflectionHelper.getDefaultImplementation(Reference.class), ReflectionHelper.getDefaultImplementation(Key.class));
    }

    public static boolean sameAs(Reference ref1, Reference ref2) {
        boolean ref2Empty;
        boolean ref1Empty = ref1 == null || ref1.getKeys() == null || ref1.getKeys().isEmpty();
        boolean bl = ref2Empty = ref2 == null || ref2.getKeys() == null || ref2.getKeys().isEmpty();
        if (ref1Empty && ref2Empty) {
            return true;
        }
        if (ref1Empty != ref2Empty) {
            return false;
        }
        int keyLength = Math.min(ref1.getKeys().size(), ref2.getKeys().size());
        for (int i = 0; i < keyLength; ++i) {
            Key ref1Key = ref1.getKeys().get(ref1.getKeys().size() - (i + 1));
            Key ref2Key = ref2.getKeys().get(ref2.getKeys().size() - (i + 1));
            Class<?> ref1Type = AasUtils.keyTypeToClass(ref1Key.getType());
            Class<?> ref2Type = AasUtils.keyTypeToClass(ref2Key.getType());
            if (ref1Type == null && ref2Type != null || ref1Type != null && ref2Type == null) {
                return false;
            }
            if (ref1Type != ref2Type && !ref1Type.isAssignableFrom(ref2Type) && !ref2Type.isAssignableFrom(ref1Type)) {
                return false;
            }
            if (!Objects.equal((Object)ref1Key.getIdType(), (Object)ref2Key.getIdType()) || !Objects.equal(ref1Key.getValue(), ref2Key.getValue())) {
                return false;
            }
            if (ref1Key.getIdType() != KeyType.IRI && ref1Key.getIdType() != KeyType.IRDI && ref1Key.getIdType() != KeyType.CUSTOM) continue;
            return true;
        }
        return true;
    }

    public static Reference clone(Reference reference) {
        return AasUtils.clone(reference, ReflectionHelper.getDefaultImplementation(Reference.class), ReflectionHelper.getDefaultImplementation(Key.class));
    }

    public static Reference clone(Reference reference, Class<? extends Reference> referenceType, Class<? extends Key> keyType) {
        if (reference == null || reference.getKeys() == null || reference.getKeys().isEmpty()) {
            return null;
        }
        try {
            Reference result = referenceType.getConstructor(new Class[0]).newInstance(new Object[0]);
            ArrayList<Key> newKeys = new ArrayList<Key>();
            for (Key key : reference.getKeys()) {
                Key newKey = keyType.getConstructor(new Class[0]).newInstance(new Object[0]);
                newKey.setType(key.getType());
                newKey.setIdType(key.getIdType());
                newKey.setValue(key.getValue());
                newKeys.add(newKey);
            }
            result.setKeys(newKeys);
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalArgumentException("error parsing reference - could not instantiate reference type", ex);
        }
    }

    public static Referable resolve(Reference reference, AssetAdministrationShellEnvironment env) {
        return AasUtils.resolve(reference, env, Referable.class);
    }

    public static <T extends Referable> T resolve(Reference reference, AssetAdministrationShellEnvironment env, Class<T> type) {
        Key key;
        if (reference == null || reference.getKeys() == null || reference.getKeys().isEmpty()) {
            return null;
        }
        Set<Identifiable> identifiables = new IdentifiableCollector(env).collect();
        Object current = null;
        int i = reference.getKeys().size() - 1;
        if (type != null) {
            Class<?> actualType = AasUtils.keyTypeToClass(reference.getKeys().get(i).getType());
            if (actualType == null) {
                log.warn("reference {} could not be resolved as key type has no known class.", (Object)AasUtils.asString(reference));
                return null;
            }
            if (!type.isAssignableFrom(actualType)) {
                log.warn("reference {} could not be resolved as target type is not assignable from actual type (target: {}, actual: {})", AasUtils.asString(reference), type.getName(), actualType.getName());
                return null;
            }
        }
        while (i >= 0) {
            key = reference.getKeys().get(i);
            Class<?> referencedType = AasUtils.keyTypeToClass(key.getType());
            if (referencedType != null) {
                List matchingIdentifiables = identifiables.stream().filter(x -> referencedType.isAssignableFrom(x.getClass())).filter(x -> key.getIdType().name().equals(x.getIdentification().getIdType().name())).filter(x -> x.getIdentification().getIdentifier().equals(key.getValue())).collect(Collectors.toList());
                if (matchingIdentifiables.size() > 1) {
                    throw new IllegalArgumentException("found multiple matching Identifiables for id '" + key.getValue() + "'");
                }
                if (matchingIdentifiables.size() == 1) {
                    current = matchingIdentifiables.get(0);
                    break;
                }
            }
            --i;
        }
        if (current == null) {
            return null;
        }
        if (++i == reference.getKeys().size()) {
            return (T)((Referable)current);
        }
        while (i < reference.getKeys().size()) {
            key = reference.getKeys().get(i);
            Class<?> keyType = AasUtils.keyTypeToClass(key.getType());
            if (keyType != null) {
                Collection collection;
                if (Operation.class.isAssignableFrom(current.getClass())) {
                    Operation operation = (Operation)current;
                    collection = Stream.of(operation.getInputVariables().stream(), operation.getOutputVariables().stream(), operation.getInoutputVariables().stream()).flatMap(x -> x.map(y -> y.getValue())).collect(Collectors.toSet());
                } else {
                    List matchingProperties = AasUtils.getAasProperties(current.getClass()).stream().filter(x -> Collection.class.isAssignableFrom(x.getReadMethod().getReturnType())).filter(x -> TypeToken.of(x.getReadMethod().getGenericReturnType()).resolveType(Collection.class.getTypeParameters()[0]).isSupertypeOf(keyType)).collect(Collectors.toList());
                    if (matchingProperties.isEmpty()) {
                        throw new IllegalArgumentException(String.format("error resolving reference - could not find matching property for type %s in class %s", keyType.getSimpleName(), current.getClass().getSimpleName()));
                    }
                    if (matchingProperties.size() > 1) {
                        throw new IllegalArgumentException(String.format("error resolving reference - found %d possible property paths for class %s (%s)", matchingProperties.size(), current.getClass().getSimpleName(), matchingProperties.stream().map(x -> x.getName()).collect(Collectors.joining(", "))));
                    }
                    try {
                        collection = (Collection)((PropertyDescriptor)matchingProperties.get(0)).getReadMethod().invoke(current, new Object[0]);
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("error resolving reference", ex);
                    }
                    Optional<Object> next = collection.stream().filter(x -> ((Referable)x).getIdShort().equals(key.getValue())).findFirst();
                    if (next.isEmpty()) {
                        throw new IllegalArgumentException("error resolving reference - could not find idShort " + key.getValue());
                    }
                    current = next.get();
                }
            }
            ++i;
        }
        return (T)((Referable)current);
    }

    public static List<PropertyDescriptor> getAasProperties(Class<?> type) {
        Class<Object> aasType = ReflectionHelper.getAasInterface(type);
        if (aasType == null) {
            aasType = ReflectionHelper.INTERFACES_WITHOUT_DEFAULT_IMPLEMENTATION.stream().filter(x -> x.isAssignableFrom(type)).map(x -> TypeToken.of(x)).sorted(new MostSpecificTypeTokenComparator()).findFirst().get().getRawType();
        }
        HashSet types = new HashSet();
        if (aasType != null) {
            types.add(aasType);
            types.addAll(ReflectionHelper.getSuperTypes(aasType, true));
        }
        return types.stream().flatMap(x -> {
            try {
                return Stream.of(Introspector.getBeanInfo(x).getPropertyDescriptors());
            }
            catch (IntrospectionException ex) {
                log.warn("error finding properties of class '{}'", (Object)type, (Object)ex);
                return Stream.empty();
            }
        }).sorted(Comparator.comparing(x -> x.getName())).collect(Collectors.toList());
    }
}

