/*
 * Decompiled with CFR 0.152.
 */
package io.adminshell.aas.v3.dataformat.core.deserialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.adminshell.aas.v3.dataformat.core.DataSpecificationManager;
import io.adminshell.aas.v3.model.DataSpecificationContent;
import io.adminshell.aas.v3.model.EmbeddedDataSpecification;
import io.adminshell.aas.v3.model.Reference;
import io.adminshell.aas.v3.model.impl.DefaultEmbeddedDataSpecification;
import java.io.IOException;

public class EmbeddedDataSpecificationDeserializer
extends JsonDeserializer<EmbeddedDataSpecification> {
    @Override
    public EmbeddedDataSpecification deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        Object temp = parser.getCodec().readTree(parser);
        ObjectNode node = (ObjectNode)temp;
        if (node == null) {
            return null;
        }
        JsonNode nodeDataSpecification = node.get("dataSpecification");
        if (nodeDataSpecification == null) {
            throw new JsonMappingException(parser, String.format("data specification must contain node '%s'", "dataSpecification"));
        }
        JsonParser parserReference = parser.getCodec().getFactory().getCodec().treeAsTokens(nodeDataSpecification);
        parserReference.nextToken();
        Reference reference = parserReference.readValueAs(Reference.class);
        JsonNode nodeContent = node.get("dataSpecificationContent");
        if (nodeContent != null) {
            Class<? extends DataSpecificationContent> targetClass = DataSpecificationManager.getDataSpecification(reference).getType();
            JsonParser parserContent = parser.getCodec().getFactory().getCodec().treeAsTokens(nodeContent);
            parserContent.nextToken();
            DataSpecificationContent content = parserContent.readValueAs(targetClass);
            return (EmbeddedDataSpecification)((DefaultEmbeddedDataSpecification.Builder)new DefaultEmbeddedDataSpecification.Builder().dataSpecificationContent(content)).build();
        }
        return (EmbeddedDataSpecification)((DefaultEmbeddedDataSpecification.Builder)new DefaultEmbeddedDataSpecification.Builder().dataSpecification(reference)).build();
    }
}

