/*
 * Decompiled with CFR 0.152.
 */
package io.adminshell.aas.v3.dataformat.core;

import com.google.common.reflect.TypeToken;
import io.adminshell.aas.v3.dataformat.core.util.MostSpecificTypeTokenComparator;
import io.adminshell.aas.v3.model.Constraint;
import io.adminshell.aas.v3.model.Referable;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionHelper {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionHelper.class);
    private static final String ROOT_PACKAGE_NAME = "io.adminshell.aas.v3";
    public static final String MODEL_PACKAGE_NAME = "io.adminshell.aas.v3.model";
    public static final String DEFAULT_IMPLEMENTATION_PACKAGE_NAME = "io.adminshell.aas.v3.model.impl";
    public static final String JSON_MIXINS_PACKAGE_NAME = "io.adminshell.aas.v3.dataformat.json.mixins";
    public static final String XML_MIXINS_PACKAGE_NAME = "io.adminshell.aas.v3.dataformat.xml.mixins";
    public static final String MIXIN_SUFFIX = "Mixin";
    public static final String DEFAULT_IMPLEMENTATION_PREFIX = "Default";
    public static final Set<Class<?>> MODEL_TYPE_SUPERCLASSES = Set.of(Referable.class, Constraint.class);
    public static final Set<Class<?>> TYPES_WITH_MODEL_TYPE;
    public static final Map<Class<?>, Set<Class<?>>> SUBTYPES;
    public static final Set<Class> INTERFACES;
    public static final Map<Class<?>, Class<?>> JSON_MIXINS;
    public static final Map<Class<?>, Class<?>> XML_MIXINS;
    public static final List<ImplementationInfo> DEFAULT_IMPLEMENTATIONS;
    public static final Set<Class<?>> INTERFACES_WITHOUT_DEFAULT_IMPLEMENTATION;
    public static final List<Class<Enum>> ENUMS;

    public static boolean isModelInterface(Class<?> type) {
        return type.isInterface() && MODEL_PACKAGE_NAME.equals(type.getPackageName());
    }

    public static boolean isDefaultImplementation(Class<?> type) {
        return DEFAULT_IMPLEMENTATIONS.stream().anyMatch(x -> Objects.equals(x.getImplementationType(), type));
    }

    public static boolean hasDefaultImplementation(Class<?> interfaceType) {
        return DEFAULT_IMPLEMENTATIONS.stream().anyMatch(x -> x.getInterfaceType().equals(interfaceType));
    }

    public static <T> Class<? extends T> getDefaultImplementation(Class<T> interfaceType) {
        if (ReflectionHelper.isDefaultImplementation(interfaceType)) {
            return interfaceType;
        }
        if (ReflectionHelper.hasDefaultImplementation(interfaceType)) {
            return DEFAULT_IMPLEMENTATIONS.stream().filter(x -> x.getInterfaceType().equals(interfaceType)).findFirst().get().getImplementationType();
        }
        return null;
    }

    public static boolean isModelInterfaceOrDefaultImplementation(Class<?> type) {
        return ReflectionHelper.isModelInterface(type) || ReflectionHelper.isDefaultImplementation(type);
    }

    public static Class<?> getAasInterface(Class<?> type) {
        Set<Class<?>> implementedAasInterfaces = ReflectionHelper.getAasInterfaces(type);
        if (implementedAasInterfaces.isEmpty()) {
            return null;
        }
        if (implementedAasInterfaces.size() == 1) {
            return implementedAasInterfaces.iterator().next();
        }
        logger.warn("class '{}' implements more than one AAS interface, but only most specific one is returned", (Object)type.getName());
        return implementedAasInterfaces.stream().map(x -> TypeToken.of(x)).sorted(new MostSpecificTypeTokenComparator()).findFirst().get().getRawType();
    }

    public static Set<Class<?>> getAasInterfaces(Class<?> type) {
        HashSet result = new HashSet();
        if (type != null) {
            if (INTERFACES.contains(type)) {
                result.add(type);
            }
            result.addAll(ClassUtils.getAllInterfaces(type).stream().filter(x -> INTERFACES.contains(x)).collect(Collectors.toSet()));
        }
        return result;
    }

    public static String getModelType(Class<?> clazz) {
        Class<?> type = ReflectionHelper.getMostSpecificTypeWithModelType(clazz);
        if (type != null) {
            return type.getSimpleName();
        }
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            String result = ReflectionHelper.getModelType(interfaceClass);
            if (result == null) continue;
            return result;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return ReflectionHelper.getModelType(superClass);
        }
        return null;
    }

    public static Class<?> getMostSpecificTypeWithModelType(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return TYPES_WITH_MODEL_TYPE.stream().filter(x -> clazz.isInterface() ? x.equals(clazz) : x.isAssignableFrom(clazz)).sorted((o1, o2) -> {
            if (o1.isAssignableFrom((Class<?>)o2)) {
                if (o2.isAssignableFrom((Class<?>)o1)) {
                    return 0;
                }
                return 1;
            }
            if (o2.isAssignableFrom((Class<?>)o1)) {
                return -1;
            }
            return 0;
        }).findFirst().orElse(null);
    }

    private static Set<Class<?>> getInterfacesWithoutDefaultImplementation(ScanResult modelScan) {
        return modelScan.getAllInterfaces().loadClasses().stream().filter(x -> !ReflectionHelper.hasDefaultImplementation(x)).collect(Collectors.toSet());
    }

    public static Set<Class<?>> getSuperTypes(Class<?> clazz, boolean recursive) {
        Set<Class<?>> result = SUBTYPES.entrySet().stream().filter(x -> ((Set)x.getValue()).contains(clazz)).map(x -> (Class)x.getKey()).collect(Collectors.toSet());
        if (recursive) {
            result.addAll(result.stream().flatMap(x -> ReflectionHelper.getSuperTypes(x, true).stream()).collect(Collectors.toSet()));
        }
        return result;
    }

    private static List<ImplementationInfo> scanDefaultImplementations(ScanResult modelScan) {
        ScanResult defaulImplementationScan = new ClassGraph().enableClassInfo().acceptPackagesNonRecursive(DEFAULT_IMPLEMENTATION_PACKAGE_NAME).scan();
        ArrayList<ImplementationInfo> defaultImplementations = new ArrayList<ImplementationInfo>();
        defaulImplementationScan.getAllClasses().filter(x -> x.getSimpleName().startsWith(DEFAULT_IMPLEMENTATION_PREFIX)).loadClasses().stream().forEach(x -> {
            String interfaceName = x.getSimpleName().substring(DEFAULT_IMPLEMENTATION_PREFIX.length());
            ClassInfoList interfaceClassInfos = modelScan.getAllClasses().filter(y -> y.isInterface() && Objects.equals(y.getSimpleName(), interfaceName));
            if (interfaceClassInfos.isEmpty()) {
                logger.warn("could not find interface realized by default implementation class '{}'", (Object)x.getSimpleName());
            } else {
                Class<?> implementedClass = ((ClassInfo)interfaceClassInfos.get(0)).loadClass();
                defaultImplementations.add(new ImplementationInfo(implementedClass, (Class<?>)x));
                logger.info("using default implementation class '{}' for interface '{}'", (Object)x.getSimpleName(), (Object)((ClassInfo)interfaceClassInfos.get(0)).getName());
            }
        });
        return defaultImplementations;
    }

    private static Set<Class> scanAasInterfaces() {
        return DEFAULT_IMPLEMENTATIONS.stream().map(x -> x.interfaceType).collect(Collectors.toSet());
    }

    private static Map<Class<?>, Class<?>> scanMixins(ScanResult modelScan, String packageName) {
        ScanResult mixinScan = new ClassGraph().enableClassInfo().acceptPackagesNonRecursive(packageName).scan();
        HashMap mixins = new HashMap();
        mixinScan.getAllClasses().filter(x -> x.getSimpleName().endsWith(MIXIN_SUFFIX)).loadClasses().forEach(x -> {
            String modelClassName = x.getSimpleName().substring(0, x.getSimpleName().length() - MIXIN_SUFFIX.length());
            ClassInfoList modelClassInfos = modelScan.getAllClasses().filter(y -> Objects.equals(y.getSimpleName(), modelClassName));
            if (modelClassInfos.isEmpty()) {
                logger.warn("could not auto-resolve target class for mixin '{}'", (Object)x.getSimpleName());
            } else {
                mixins.put(((ClassInfo)modelClassInfos.get(0)).loadClass(), (Class<?>)x);
                logger.info("using mixin '{}' for class '{}'", (Object)x.getSimpleName(), (Object)((ClassInfo)modelClassInfos.get(0)).getName());
            }
        });
        return mixins;
    }

    private static Map<Class<?>, Set<Class<?>>> scanSubtypes(ScanResult modelScan) {
        return modelScan.getAllInterfaces().stream().filter(ReflectionHelper::hasSubclass).collect(Collectors.toMap(ClassInfo::loadClass, ReflectionHelper::getSubclasses));
    }

    private static Set<Class<?>> getSubclasses(ClassInfo clazzInfo) {
        return clazzInfo.getClassesImplementing().directOnly().filter(ClassInfo::isInterface).loadClasses().stream().collect(Collectors.toSet());
    }

    private static boolean hasSubclass(ClassInfo clazzInfo) {
        return !ReflectionHelper.getSubclasses(clazzInfo).isEmpty();
    }

    private static Set<Class<?>> scanModelTypes(ScanResult modelScan) {
        Set<Class<?>> typesWithModelTypes = MODEL_TYPE_SUPERCLASSES.stream().flatMap(x -> modelScan.getClassesImplementing(x.getName()).loadClasses().stream()).collect(Collectors.toSet());
        typesWithModelTypes.addAll(MODEL_TYPE_SUPERCLASSES);
        return typesWithModelTypes;
    }

    private ReflectionHelper() {
    }

    static {
        ScanResult modelScan = new ClassGraph().enableClassInfo().acceptPackagesNonRecursive(MODEL_PACKAGE_NAME).scan();
        TYPES_WITH_MODEL_TYPE = ReflectionHelper.scanModelTypes(modelScan);
        SUBTYPES = ReflectionHelper.scanSubtypes(modelScan);
        JSON_MIXINS = ReflectionHelper.scanMixins(modelScan, JSON_MIXINS_PACKAGE_NAME);
        XML_MIXINS = ReflectionHelper.scanMixins(modelScan, XML_MIXINS_PACKAGE_NAME);
        DEFAULT_IMPLEMENTATIONS = ReflectionHelper.scanDefaultImplementations(modelScan);
        INTERFACES = ReflectionHelper.scanAasInterfaces();
        ENUMS = modelScan.getAllEnums().loadClasses(Enum.class);
        INTERFACES_WITHOUT_DEFAULT_IMPLEMENTATION = ReflectionHelper.getInterfacesWithoutDefaultImplementation(modelScan);
    }

    public static class ImplementationInfo<T> {
        private final Class<T> interfaceType;
        private final Class<? extends T> implementationType;

        protected ImplementationInfo(Class<T> interfaceType, Class<? extends T> implementationType) {
            this.interfaceType = interfaceType;
            this.implementationType = implementationType;
        }

        public Class<T> getInterfaceType() {
            return this.interfaceType;
        }

        public Class<? extends T> getImplementationType() {
            return this.implementationType;
        }
    }
}

