/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.faaast.converter.packageexplorer;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.LevelFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.spi.FilterReply;
import de.fraunhofer.iosb.ilt.faaast.converter.packageexplorer.PackageExplorerConverter;
import io.adminshell.aas.v3.dataformat.DeserializationException;
import io.adminshell.aas.v3.dataformat.SerializationException;
import io.adminshell.aas.v3.dataformat.json.JsonDeserializer;
import io.adminshell.aas.v3.dataformat.json.JsonSerializer;
import io.adminshell.aas.v3.model.AssetAdministrationShellEnvironment;
import io.adminshell.aas.v3.model.impl.DefaultAssetAdministrationShellEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="FA\u00b3ST Package Explorer JSON Converter", mixinStandardHelpOptions=true, description={"Converts AAS JSON files exported with Package Explorer to a FA\u00b3ST-compatible version."}, version={"0.0.1-SNAPSHOT"}, usageHelpAutoWidth=true)
public class App
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(App.class);
    private static final String JSON_FILE_EXTENSION = ".json";
    private static final String MERGE_FILE_NAME = "merged.json";
    @CommandLine.Option(names={"-i", "--input"}, description={"Input file or directory"}, required=true)
    private File input = null;
    @CommandLine.Option(names={"-o", "--output"}, description={"Output file or directory"})
    private File output = null;
    @CommandLine.Option(names={"-d", "--debug"}, description={"Print additional debug information"})
    private boolean debug;
    @CommandLine.Option(names={"-m", "--merge"}, description={"Merge all AAS models into a single file called 'merged.json' additionally to converting each file seperately (only applicable if input contains multiple files)"})
    private boolean merge;

    public static void main(String[] args) throws ScriptException, DeserializationException, SerializationException {
        int exitCode = new CommandLine(new App()).execute(args);
        System.exit(exitCode);
    }

    private Integer convertSingleFile() {
        if (this.merge) {
            LOGGER.warn("Merging not supported when converting single file - command will be ignored");
        }
        return this.convert(this.input, this.output) != null ? 0 : 1;
    }

    private boolean output(AssetAdministrationShellEnvironment env, File outputFile) {
        if (outputFile == null) {
            LOGGER.info("");
            try {
                LOGGER.info("Result: \n{}", (Object)new JsonSerializer().write(env));
            }
            catch (SerializationException e) {
                LOGGER.error("Serialization with FA\u00b3ST failed", e);
            }
        } else {
            File path = outputFile.getParentFile();
            if (path != null && !path.exists() && !path.mkdirs()) {
                LOGGER.error("path '{}' could not be created", (Object)path);
                return false;
            }
            try {
                new JsonSerializer().write(outputFile, env);
            }
            catch (SerializationException | IOException e) {
                LOGGER.error("Error writing to output file", e);
                return false;
            }
            LOGGER.info("Output written to {}", (Object)outputFile);
        }
        return true;
    }

    private AssetAdministrationShellEnvironment convert(File inputFile, File outputFile) {
        LOGGER.info("Input file: {}", (Object)inputFile);
        if (outputFile != null) {
            LOGGER.info("Output file: {}", (Object)outputFile);
        }
        LOGGER.info("");
        AssetAdministrationShellEnvironment aasConverted = null;
        try {
            aasConverted = new JsonDeserializer().read(inputFile);
            LOGGER.info("File is already FA\u00b3ST-compliant");
        }
        catch (DeserializationException | FileNotFoundException exception) {
            // empty catch block
        }
        if (aasConverted == null) {
            LOGGER.info("Converting file...");
            String converted = "";
            try {
                converted = new String(PackageExplorerConverter.toFaaast(new FileInputStream(inputFile)).readAllBytes());
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Input file not found", e);
                return null;
            }
            catch (IOException e) {
                LOGGER.error("Error reading input file", e);
                return null;
            }
            LOGGER.info("Testing deserialization with FA\u00b3ST...");
            try {
                aasConverted = new JsonDeserializer().read(converted);
            }
            catch (DeserializationException e) {
                LOGGER.warn("Conversion result could not be deserialized using FA\u00b3ST", e);
                return null;
            }
            LOGGER.info("Conversion successfully finished");
        }
        return this.output(aasConverted, outputFile) ? aasConverted : null;
    }

    private Integer convertBatch() {
        LOGGER.info("Scanning input directory '{}' for JSON files...:", (Object)this.input);
        File[] inputFiles = this.input.listFiles((file, name) -> name.endsWith(JSON_FILE_EXTENSION));
        LOGGER.info("Found {} files in input directory:{}{}", inputFiles.length, System.lineSeparator(), Stream.of(inputFiles).map(x -> x.getName()).collect(Collectors.joining(System.lineSeparator())));
        if (this.output != null && this.output.isFile()) {
            LOGGER.error("Output is not a directory! When using batch mode, output must be a directory or be omitted");
            return 1;
        }
        ArrayList<File> failures = new ArrayList<File>();
        ArrayList<AssetAdministrationShellEnvironment> aass = new ArrayList<AssetAdministrationShellEnvironment>();
        for (int i = 0; i < inputFiles.length; ++i) {
            File in = inputFiles[i];
            File out = this.output != null ? new File(this.output, in.getName()) : null;
            LOGGER.info("Processing file [{}/{}]: '{}'...:", i + 1, inputFiles.length, in.getName());
            try {
                LOGGER.info("");
                AssetAdministrationShellEnvironment conversionResult = this.convert(in, out);
                if (conversionResult == null) {
                    failures.add(in);
                } else {
                    aass.add(conversionResult);
                }
                LOGGER.info("");
                LOGGER.info("");
                continue;
            }
            catch (Exception e) {
                LOGGER.error("unexpected error while converting", e);
                return 1;
            }
        }
        LOGGER.info("Successfully converted [{}/{}] files", (Object)(inputFiles.length - failures.size()), (Object)inputFiles.length);
        if (this.merge && failures.isEmpty() && aass.size() > 1) {
            File mergeFile = new File(this.output, MERGE_FILE_NAME);
            LOGGER.info("Merging files...");
            HashMap<String, Integer> duplicateCounter = new HashMap<String, Integer>();
            AssetAdministrationShellEnvironment mergeResult = (AssetAdministrationShellEnvironment)aass.stream().reduce((a, b) -> App.merge(a, b, duplicateCounter)).get();
            duplicateCounter.forEach((id, count) -> LOGGER.warn("Found {} elements with same identifier but different content (Identifier: {})", count, id));
            this.output(mergeResult, mergeFile);
        } else if (!failures.isEmpty()) {
            LOGGER.info("The following files could not be converted: {}{}", (Object)System.lineSeparator(), (Object)failures.stream().map(x -> x.getName()).collect(Collectors.joining(System.lineSeparator())));
            if (this.merge) {
                LOGGER.info("Merging will not be performed because of conversion errors.");
            }
        }
        return 0;
    }

    private static <T, U> List<T> merge(List<T> coll1, List<T> coll2, Function<T, U> idExtractor, Map<U, Integer> duplicateCounter) {
        coll1.stream().forEach(a -> {
            Object id = idExtractor.apply(a);
            Optional<Object> duplicate = coll2.stream().filter(b -> Objects.equals(id, idExtractor.apply(b))).findFirst();
            if (duplicate.isPresent() && !Objects.equals(a, duplicate.get())) {
                int count = duplicateCounter.containsKey(id) ? (Integer)duplicateCounter.get(id) : 0;
                duplicateCounter.put(id, ++count);
            }
        });
        return Stream.concat(coll1.stream(), coll2.stream()).distinct().collect(Collectors.toList());
    }

    private static AssetAdministrationShellEnvironment merge(AssetAdministrationShellEnvironment aas1, AssetAdministrationShellEnvironment aas2, Map<String, Integer> duplicateCounter) {
        return (AssetAdministrationShellEnvironment)((DefaultAssetAdministrationShellEnvironment.Builder)((DefaultAssetAdministrationShellEnvironment.Builder)((DefaultAssetAdministrationShellEnvironment.Builder)new DefaultAssetAdministrationShellEnvironment.Builder().assetAdministrationShells(App.merge(aas1.getAssetAdministrationShells(), aas2.getAssetAdministrationShells(), x -> x.getIdentification().getIdentifier(), duplicateCounter))).conceptDescriptions(App.merge(aas1.getConceptDescriptions(), aas2.getConceptDescriptions(), x -> x.getIdentification().getIdentifier(), duplicateCounter))).submodels(App.merge(aas1.getSubmodels(), aas2.getSubmodels(), x -> x.getIdentification().getIdentifier(), duplicateCounter))).build();
    }

    private static void enableDebug() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        LevelFilter filter = new LevelFilter();
        filter.setLevel(Level.DEBUG);
        filter.setOnMatch(FilterReply.ACCEPT);
        filter.setOnMismatch(FilterReply.ACCEPT);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern("%date{yyyy-MM-dd HH:mm:ss} %msg %n");
        encoder.setContext(context);
        encoder.start();
        ConsoleAppender<ILoggingEvent> appender = new ConsoleAppender<ILoggingEvent>();
        appender.addFilter(filter);
        appender.setEncoder(encoder);
        appender.setContext(context);
        appender.start();
        ch.qos.logback.classic.Logger logger = context.getLogger(PackageExplorerConverter.class);
        logger.setLevel(Level.DEBUG);
        logger.setAdditive(true);
        logger.addAppender((Appender<ILoggingEvent>)appender);
    }

    @Override
    public Integer call() {
        this.printHeader();
        if (this.debug) {
            App.enableDebug();
        }
        return this.input.isDirectory() ? this.convertBatch() : this.convertSingleFile();
    }

    private void printHeader() {
        LOGGER.info("             _____                                                      ");
        LOGGER.info("            |___ /                                                      ");
        LOGGER.info("  ______      |_ \\   _____ _______                                      ");
        LOGGER.info(" |  ____/\\   ___) | / ____|__   __|                                     ");
        LOGGER.info(" | |__ /  \\ |____/ | (___    | |                                        ");
        LOGGER.info(" |  __/ /\\ \\        \\___ \\   | |                                        ");
        LOGGER.info(" | | / ____ \\       ____) |  | |                                        ");
        LOGGER.info(" |_|/_/    \\_\\     |_____/   |_|                                        ");
        LOGGER.info("  ___         _                   ___          _                        ");
        LOGGER.info(" | _ \\__ _ __| |____ _ __ _ ___  | __|_ ___ __| |___ _ _ ___ _ _        ");
        LOGGER.info(" |  _/ _` / _| / / _` / _` / -_) | _|\\ \\ / '_ \\ / _ \\ '_/ -_) '_|       ");
        LOGGER.info(" |_| \\__,_\\__|_\\_\\__,_\\__, \\___| |___/_\\_\\ .__/_\\___/_| \\___|_|         ");
        LOGGER.info("                      |___/              |_|                            ");
        LOGGER.info("     _ ___  ___  _  _    ___                     _                      ");
        LOGGER.info("  _ | / __|/ _ \\| \\| |  / __|___ _ ___ _____ _ _| |_ ___ _ _            ");
        LOGGER.info(" | || \\__ \\ (_) | .` | | (__/ _ \\ ' \\ V / -_) '_|  _/ -_) '_|           ");
        LOGGER.info("  \\__/|___/\\___/|_|\\_|  \\___\\___/_||_\\_/\\___|_|  \\__\\___|_|             ");
        LOGGER.info("");
        LOGGER.info("");
    }
}

