/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.util.resource;

import com.mycila.maven.plugin.license.util.resource.CustomClassLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;

public final class ResourceFinder {
    private final Path basedir;
    private CustomClassLoader compileClassPath;
    private CustomClassLoader pluginClassPath;

    public ResourceFinder(Path basedir) {
        this.basedir = basedir;
    }

    public void setCompileClassPath(List<String> classpath) {
        this.compileClassPath = new CustomClassLoader();
        if (classpath != null) {
            for (String absolutePath : classpath) {
                this.compileClassPath.addFolder(absolutePath);
            }
        }
    }

    public void setPluginClassPath(ClassLoader classLoader) {
        this.pluginClassPath = new CustomClassLoader(classLoader);
    }

    public URL findResource(String resource) throws MojoFailureException {
        URL res = null;
        try {
            Path p = this.basedir.resolve(resource);
            res = this.toURL(p.toAbsolutePath());
        }
        catch (InvalidPathException p) {
            // empty catch block
        }
        if (res != null) {
            return res;
        }
        try {
            res = this.toURL(Paths.get(resource, new String[0]));
        }
        catch (InvalidPathException p) {
            // empty catch block
        }
        if (res != null) {
            return res;
        }
        String cpResource = resource.startsWith("/") ? resource.substring(1) : resource;
        res = this.compileClassPath.getResource(cpResource);
        if (res != null) {
            return res;
        }
        res = this.pluginClassPath.getResource(cpResource);
        if (res != null) {
            return res;
        }
        try {
            res = new URL(resource);
            res.openStream().close();
            return res;
        }
        catch (Exception e) {
            throw new MojoFailureException("Resource " + resource + " not found in file system, classpath or URL: " + e.getMessage(), e);
        }
    }

    private URL toURL(Path path) {
        if (Files.exists(path, new LinkOption[0]) && Files.isReadable(path)) {
            try {
                return path.toUri().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }
}

