/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Map;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

public final class FileUtils {
    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, String content, String encoding) throws IOException {
        try (FileChannel channel = new FileOutputStream(file).getChannel();){
            channel.write(ByteBuffer.wrap(content.getBytes(encoding)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(URL location, String encoding, Map<String, Object> properties) throws IOException {
        try (InterpolationFilterReader reader = new InterpolationFilterReader(new BufferedReader(new InputStreamReader(location.openStream(), encoding)), properties);){
            String string = IOUtil.toString(reader);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(URL location, String encoding) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(location.openStream(), encoding));){
            String string = IOUtil.toString(reader);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] read(URL[] locations, String encoding) throws IOException {
        String[] results = new String[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(locations[i].openStream(), encoding));){
                results[i] = IOUtil.toString(reader);
                continue;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file, String encoding) throws IOException {
        try (FileChannel in = new FileInputStream(file).getChannel();){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            in.transferTo(0L, in.size(), Channels.newChannel(baos));
            String string = baos.toString(encoding);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFirstLines(File file, int lineCount, String encoding) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));){
            String line;
            StringBuilder sb = new StringBuilder();
            while (lineCount > 0 && (line = reader.readLine()) != null) {
                --lineCount;
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    public static String remove(String str, String ... chars) {
        for (String s2 : chars) {
            str = str.replace(s2, "");
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileToFolder(File file, File folder) throws IOException {
        File dest = new File(folder, file.getName());
        FileChannel inChannel = new FileInputStream(file).getChannel();
        FileChannel outChannel = new FileOutputStream(dest).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static Path asPath(File file) {
        if (file == null) {
            return null;
        }
        return file.toPath();
    }
}

