/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license;

import com.mycila.maven.plugin.license.AbstractLicenseMojo;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.header.Header;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public final class LicenseCheckMojo
extends AbstractLicenseMojo {
    @Parameter(property="license.errorMessage", defaultValue="Some files do not have the expected license header")
    public String errorMessage = "Some files do not have the expected license header";
    public final Collection<File> missingHeaders = new ConcurrentLinkedQueue<File>();

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.getLog().info("Checking licenses...");
        }
        this.missingHeaders.clear();
        AbstractLicenseMojo.AbstractCallback callback = new AbstractLicenseMojo.AbstractCallback(){

            @Override
            public void onHeaderNotFound(Document document, Header header) {
                if (LicenseCheckMojo.this.skipExistingHeaders) {
                    document.parseHeader();
                    if (document.headerDetected()) {
                        LicenseCheckMojo.this.debug("Existing header in: %s", document.getFilePath());
                        return;
                    }
                }
                LicenseCheckMojo.this.warn("Missing header in: %s", document.getFilePath());
                LicenseCheckMojo.this.missingHeaders.add(document.getFile());
            }

            @Override
            public void onExistingHeader(Document document, Header header) {
                LicenseCheckMojo.this.debug("Header OK in: %s", document.getFilePath());
            }
        };
        this.execute(callback);
        if (!this.missingHeaders.isEmpty()) {
            if (this.failIfMissing) {
                throw new MojoExecutionException(this.errorMessage);
            }
            this.getLog().warn(this.errorMessage);
        }
        if (!this.skip) {
            callback.checkUnknown();
        }
    }
}

