/*
 * Decompiled with CFR 0.152.
 */
package io.adminshell.aas.v3.dataformat.mapping;

import com.google.common.reflect.TypeToken;
import io.adminshell.aas.v3.dataformat.core.util.MostSpecificClassComparator;
import io.adminshell.aas.v3.dataformat.core.util.MostSpecificTypeTokenComparator;
import io.adminshell.aas.v3.dataformat.mapping.Mapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingProvider<T extends Mapper> {
    private static final Logger log = LoggerFactory.getLogger(MappingProvider.class);
    private final T defaultMapper;
    private final T defaultCollectionMapper;
    private final Map<TypeToken<?>, List<T>> mappings = new HashMap();

    public MappingProvider(Class<T> type, Mapper<Object> defaultMapper, Mapper<Collection<Object>> defaultCollectionMapper) {
        if (type == null) {
            throw new IllegalArgumentException("type must be non-null");
        }
        if (defaultMapper == null) {
            throw new IllegalArgumentException("defaultMapper must be non-null");
        }
        if (defaultCollectionMapper == null) {
            throw new IllegalArgumentException("defaultCollectionMapper must be non-null");
        }
        if (!type.isAssignableFrom(defaultMapper.getClass())) {
            throw new IllegalArgumentException("defaultMapper must be of type " + type);
        }
        if (!type.isAssignableFrom(defaultCollectionMapper.getClass())) {
            throw new IllegalArgumentException("defaultCollectionMapper must be of type " + type);
        }
        this.defaultMapper = defaultMapper;
        this.defaultCollectionMapper = defaultCollectionMapper;
    }

    public void register(T mapper) {
        TypeToken<?> key = this.getMappedType(mapper.getClass());
        if (!this.mappings.containsKey(key)) {
            this.mappings.put(key, new ArrayList());
        }
        this.mappings.get(key).add(mapper);
    }

    private TypeToken<?> getMappedType(Class<?> type) {
        return TypeToken.of(type).getTypes().stream().filter(y -> Mapper.class.equals(y.getRawType())).findFirst().get().resolveType(Mapper.class.getTypeParameters()[0]);
    }

    public T getMapper(Object obj) {
        if (obj == null) {
            return this.getMapper((Type)((Object)Object.class));
        }
        if (Type.class.isAssignableFrom(obj.getClass())) {
            return this.getMapper((Type)obj);
        }
        return this.getMapper(obj.getClass());
    }

    public T getMapper(Type type) {
        Optional<List> customMapper = this.mappings.entrySet().stream().filter(x -> ((TypeToken)x.getKey()).isSupertypeOf(type)).sorted((x, y) -> Objects.compare((TypeToken)x.getKey(), (TypeToken)y.getKey(), new MostSpecificTypeTokenComparator())).map(x -> (List)x.getValue()).findFirst();
        if (customMapper.isEmpty() && !TypeToken.of(Collection.class).isSupertypeOf(type)) {
            customMapper = this.mappings.entrySet().stream().filter(x -> ((TypeToken)x.getKey()).getRawType().isAssignableFrom(TypeToken.of(type).getRawType())).sorted((x, y) -> Objects.compare(((TypeToken)x.getKey()).getRawType(), ((TypeToken)y.getKey()).getRawType(), new MostSpecificClassComparator())).map(x -> (List)x.getValue()).findFirst();
        }
        if (customMapper.isEmpty() || customMapper.get().isEmpty()) {
            if (TypeToken.of(Collection.class).isSupertypeOf(type) && this.defaultCollectionMapper != null) {
                return this.defaultCollectionMapper;
            }
            return this.defaultMapper;
        }
        if (customMapper.get().size() > 1) {
            log.warn("found {} equally suitable mappers for type '{}'", (Object)customMapper.get().size(), (Object)type);
        }
        return (T)((Mapper)customMapper.get().get(0));
    }
}

