/*
 * Decompiled with CFR 0.152.
 */
package io.adminshell.aas.v3.dataformat.core.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.adminshell.aas.v3.dataformat.core.DataSpecificationInfo;
import io.adminshell.aas.v3.dataformat.core.DataSpecificationManager;
import io.adminshell.aas.v3.model.DataSpecificationContent;
import io.adminshell.aas.v3.model.EmbeddedDataSpecification;
import io.adminshell.aas.v3.model.Reference;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedDataSpecificationSerializer
extends JsonSerializer<EmbeddedDataSpecification> {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedDataSpecificationSerializer.class);

    @Override
    public void serialize(EmbeddedDataSpecification data, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (data == null) {
            return;
        }
        Reference reference = null;
        DataSpecificationContent content = data.getDataSpecificationContent();
        if (content != null) {
            DataSpecificationInfo implicitDataSpecification = DataSpecificationManager.getDataSpecification(content.getClass());
            Reference implicitType = implicitDataSpecification != null ? implicitDataSpecification.getReference() : null;
            Reference explicitType = data.getDataSpecification();
            if (implicitType == null) {
                logger.warn("Trying to serialize unknown implementation of DataSpecificationContent ({}). Use DataSpecificationManager.register(Reference reference, Class<? extends DataSpecificationContent> implementation) to register your implementation", (Object)content.getClass());
                if (explicitType == null) {
                    logger.warn("Missing type information for DataSpecificationContent! Will be serialized without type information.");
                } else {
                    reference = explicitType;
                }
            } else {
                reference = implicitType;
                if (explicitType != null && !Objects.equals(implicitType, explicitType)) {
                    logger.warn("Conflicting type information for DataSpecificationContent (implicit type: {}, explicit type: {}). Explicit type will be used.", (Object)implicitType, (Object)explicitType);
                    reference = explicitType;
                }
            }
        }
        if (reference != null || content != null) {
            generator.writeStartObject();
        }
        if (reference != null) {
            generator.writeObjectField("dataSpecification", reference);
        }
        if (content != null) {
            generator.writeObjectField("dataSpecificationContent", content);
        }
        if (reference != null || content != null) {
            generator.writeEndObject();
        }
    }

    @Override
    public void serializeWithType(EmbeddedDataSpecification data, JsonGenerator generator, SerializerProvider provider, TypeSerializer typedSerializer) throws IOException, JsonProcessingException {
        this.serialize(data, generator, provider);
    }
}

