/*
 * Decompiled with CFR 0.152.
 */
package io.adminshell.aas.v3.dataformat.core;

import io.adminshell.aas.v3.dataformat.core.DataSpecificationInfo;
import io.adminshell.aas.v3.dataformat.core.util.AasUtils;
import io.adminshell.aas.v3.model.DataSpecificationContent;
import io.adminshell.aas.v3.model.DataSpecificationIEC61360;
import io.adminshell.aas.v3.model.Key;
import io.adminshell.aas.v3.model.KeyElements;
import io.adminshell.aas.v3.model.KeyType;
import io.adminshell.aas.v3.model.Reference;
import io.adminshell.aas.v3.model.impl.DefaultKey;
import io.adminshell.aas.v3.model.impl.DefaultReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class DataSpecificationManager {
    public static final String PROP_DATA_SPECIFICATION = "dataSpecification";
    public static final String PROP_DATA_SPECIFICATION_CONTENT = "dataSpecificationContent";
    public static final String DATA_SPECIFICATION_IEC61360_IRI = "http://admin-shell.io/DataSpecificationTemplates/DataSpecificationIEC61360/2/0";
    public static final String DATA_SPECIFICATION_IEC61360_PREFIX = "IEC";
    private static final Set<DataSpecificationInfo> KNOWN_IMPLEMENTATIONS = new HashSet<DataSpecificationInfo>(Arrays.asList(new DataSpecificationInfo(DataSpecificationIEC61360.class, DataSpecificationManager.createGlobalIri("http://admin-shell.io/DataSpecificationTemplates/DataSpecificationIEC61360/2/0"), "IEC")));

    public static void register(DataSpecificationInfo dataSpecification) {
        KNOWN_IMPLEMENTATIONS.add(dataSpecification);
    }

    private static Reference createGlobalIri(String iri) {
        return (Reference)((DefaultReference.Builder)new DefaultReference.Builder().keys(Arrays.asList((Key)((DefaultKey.Builder)((DefaultKey.Builder)((DefaultKey.Builder)new DefaultKey.Builder().idType(KeyType.IRI)).type(KeyElements.GLOBAL_REFERENCE)).value(iri)).build()))).build();
    }

    public static DataSpecificationInfo getDataSpecification(Class<? extends DataSpecificationContent> implementation) {
        DataSpecificationInfo result = DataSpecificationManager.getDataSpecification((DataSpecificationInfo x) -> Objects.equals(x.getType(), implementation));
        if (result == null) {
            result = DataSpecificationManager.getDataSpecification((DataSpecificationInfo x) -> x.getType().isAssignableFrom(implementation));
        }
        return result;
    }

    public static DataSpecificationInfo getDataSpecification(Reference reference) {
        return DataSpecificationManager.getDataSpecification((DataSpecificationInfo x) -> AasUtils.sameAs(x.getReference(), reference));
    }

    private static DataSpecificationInfo getDataSpecification(Predicate<DataSpecificationInfo> filter) {
        Optional<DataSpecificationInfo> exactMatch = KNOWN_IMPLEMENTATIONS.stream().filter(filter).findFirst();
        if (exactMatch.isPresent()) {
            return exactMatch.get();
        }
        return null;
    }
}

